"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetInventorySearchBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../common/lib/kibana");
var _filters_global = require("../../common/components/filters_global/filters_global");
var _data_view_context = require("../hooks/data_view_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AssetInventorySearchBar = ({
  query,
  setQuery,
  placeholder = _i18n.i18n.translate('xpack.securitySolution.assetInventory.searchBar.searchPlaceholder', {
    defaultMessage: 'Filter your data using KQL syntax'
  }),
  isLoading
}) => {
  var _query$query, _query$query2;
  const {
    dataView
  } = (0, _data_view_context.useDataViewContext)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    unifiedSearch: {
      ui: {
        SearchBar
      }
    }
  } = (0, _kibana.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, null, /*#__PURE__*/_react.default.createElement("div", {
    css: {
      borderBottom: euiTheme.border.thin
    }
  }, /*#__PURE__*/_react.default.createElement(SearchBar, {
    appName: "Asset Inventory",
    showFilterBar: true,
    showQueryInput: true,
    showDatePicker: false,
    indexPatterns: [dataView],
    onQuerySubmit: setQuery,
    onFiltersUpdated: newFilters => setQuery({
      filters: newFilters
    }),
    placeholder: placeholder,
    query: {
      query: (query === null || query === void 0 ? void 0 : (_query$query = query.query) === null || _query$query === void 0 ? void 0 : _query$query.query) || '',
      language: (query === null || query === void 0 ? void 0 : (_query$query2 = query.query) === null || _query$query2 === void 0 ? void 0 : _query$query2.language) || 'kuery'
    },
    isLoading: isLoading
  })));
};
exports.AssetInventorySearchBar = AssetInventorySearchBar;