"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkUpsertAssetCriticalityRecordsResponse = exports.BulkUpsertAssetCriticalityRecordsRequestBody = exports.AssetCriticalityLevelsForBulkUploadEnum = exports.AssetCriticalityLevelsForBulkUpload = exports.AssetCriticalityBulkUploadStats = exports.AssetCriticalityBulkUploadErrorItem = void 0;
var _zod = require("@kbn/zod");
var _common = require("./common.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Asset Criticality Bulk Upsert Schema
 *   version: 2023-10-31
 */

const AssetCriticalityBulkUploadErrorItem = exports.AssetCriticalityBulkUploadErrorItem = _zod.z.object({
  message: _zod.z.string(),
  index: _zod.z.number().int()
});
const AssetCriticalityBulkUploadStats = exports.AssetCriticalityBulkUploadStats = _zod.z.object({
  successful: _zod.z.number().int(),
  failed: _zod.z.number().int(),
  total: _zod.z.number().int()
});

/**
 * The criticality level of the asset for bulk upload. The value `unassigned` is used to indicate that the criticality level is not assigned and is only used for bulk upload.
 */

const AssetCriticalityLevelsForBulkUpload = exports.AssetCriticalityLevelsForBulkUpload = _zod.z.enum(['low_impact', 'medium_impact', 'high_impact', 'extreme_impact', 'unassigned']);
const AssetCriticalityLevelsForBulkUploadEnum = exports.AssetCriticalityLevelsForBulkUploadEnum = AssetCriticalityLevelsForBulkUpload.enum;
const BulkUpsertAssetCriticalityRecordsRequestBody = exports.BulkUpsertAssetCriticalityRecordsRequestBody = _zod.z.object({
  records: _zod.z.array(_common.AssetCriticalityRecordIdParts.merge(_zod.z.object({
    criticality_level: AssetCriticalityLevelsForBulkUpload
  }))).min(1).max(1000)
});
const BulkUpsertAssetCriticalityRecordsResponse = exports.BulkUpsertAssetCriticalityRecordsResponse = _zod.z.object({
  errors: _zod.z.array(AssetCriticalityBulkUploadErrorItem),
  stats: AssetCriticalityBulkUploadStats
});