"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShardDetailTree = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shard_details_tree_node = require("./shard_details_tree_node");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ShardDetailTree = ({
  data,
  index,
  shard
}) => {
  const renderOperations = operation => {
    const nextOperation = operation.treeRoot || operation;
    return /*#__PURE__*/_react.default.createElement(_shard_details_tree_node.ShardDetailsTreeNode, {
      shard: shard,
      index: index,
      operation: nextOperation
    });
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "prfDevTool__profileTree__panelBody"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "none",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "prfDevTool__profileTree__tvHeader"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: "euiTextAlign--left prfDevTool__profileTree__cell"
  }, _i18n.i18n.translate('xpack.searchProfiler.profileTree.header.typeTitle', {
    defaultMessage: 'Type and description'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: "prfDevTool__profileTree__cell prfDevTool__profileTree__time"
  }, _i18n.i18n.translate('xpack.searchProfiler.profileTree.header.selfTimeTitle', {
    defaultMessage: 'Self time'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: "prfDevTool__profileTree__cell prfDevTool__profileTree__time"
  }, _i18n.i18n.translate('xpack.searchProfiler.profileTree.header.totalTimeTitle', {
    defaultMessage: 'Total time'
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "prfDevTool__profileTree__cell prfDevTool__profileTree__percentage"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, renderOperations(data))));
};
exports.ShardDetailTree = ShardDetailTree;