"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfileQueryEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _lzString = require("lz-string");
var _hooks = require("../../hooks");
var _app_context = require("../../contexts/app_context");
var _profiler_context = require("../../contexts/profiler_context");
var _editor = require("./editor");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_INDEX_VALUE = '_all';
const INITIAL_EDITOR_VALUE = `{
  "query":{
    "match_all" : {}
  }
}`;

/**
 * This component should only need to render once.
 *
 * Drives state changes for mine via profiler action context.
 */
const ProfileQueryEditor = exports.ProfileQueryEditor = /*#__PURE__*/(0, _react.memo)(() => {
  const editorPropsRef = (0, _react.useRef)(null);
  const indexInputRef = (0, _react.useRef)(null);
  const dispatch = (0, _profiler_context.useProfilerActionContext)();
  const {
    getLicenseStatus,
    notifications,
    location
  } = (0, _app_context.useAppContext)();
  const {
    data: indicesData,
    isLoading,
    error: indicesDataError
  } = (0, _hooks.useHasIndices)();
  const queryParams = new URLSearchParams(location.search);
  const indexName = queryParams.get('index');
  const searchProfilerQueryURI = queryParams.get('load_from');
  const searchProfilerQuery = searchProfilerQueryURI && (0, _lzString.decompressFromEncodedURIComponent)(searchProfilerQueryURI.replace(/^data:text\/plain,/, ''));
  const editorValue = (0, _react.useRef)(searchProfilerQuery || INITIAL_EDITOR_VALUE);
  const requestProfile = (0, _hooks.useRequestProfile)();
  const handleProfileClick = async () => {
    dispatch({
      type: 'setProfiling',
      value: true
    });
    try {
      const {
        data: result,
        error
      } = await requestProfile({
        query: editorValue.current,
        index: indexInputRef.current.value
      });
      if (error) {
        notifications.addDanger(error);
        editorPropsRef.current.focus();
        return;
      }
      if (result === null) {
        return;
      }
      dispatch({
        type: 'setCurrentResponse',
        value: result
      });
    } finally {
      dispatch({
        type: 'setProfiling',
        value: false
      });
    }
  };
  const onEditorReady = (0, _react.useCallback)(editorPropsInstance => editorPropsRef.current = editorPropsInstance, []);
  const licenseEnabled = getLicenseStatus().valid;
  const hasIndices = isLoading || indicesDataError ? false : indicesData === null || indicesData === void 0 ? void 0 : indicesData.hasIndices;
  const isDisabled = !licenseEnabled || !hasIndices;
  const tooltipContentDisabled = !licenseEnabled ? _i18n.i18n.translate('xpack.searchProfiler.formProfileButton.noLicenseTooltip', {
    defaultMessage: 'You need an active license to use Search Profiler'
  }) : _i18n.i18n.translate('xpack.searchProfiler.formProfileButton.noIndicesTooltip', {
    defaultMessage: 'You must have at least one index to use Search Profiler'
  });
  const tooltipContentEnabled = _i18n.i18n.translate('xpack.searchProfiler.sendRequestButtonTooltipContent', {
    defaultMessage: 'Click to send request'
  });
  const tooltipContent = isDisabled ? tooltipContentDisabled : tooltipContentEnabled;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "none",
    direction: "column",
    css: (0, _react2.css)`
        height: 100%;
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    direction: "row",
    gutterSize: "s",
    alignItems: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.searchProfiler.formIndexLabel', {
      defaultMessage: 'Index'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "indexName",
    fullWidth: true,
    disabled: !licenseEnabled,
    inputRef: ref => {
      if (ref) {
        indexInputRef.current = ref;
        ref.value = indexName ? indexName : DEFAULT_INDEX_VALUE;
      }
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tooltipContent
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: 'playFilled',
    "data-test-subj": isDisabled ? 'disabledProfileButton' : 'profileButton',
    disabled: isDisabled,
    onClick: !isDisabled ? handleProfileClick : undefined,
    size: "m",
    display: "base",
    "aria-label": _i18n.i18n.translate('xpack.searchProfiler.formProfileButtonLabel', {
      defaultMessage: 'Profile'
    })
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    css: (0, _react2.css)`
          overflow: hidden;
        `
  }, /*#__PURE__*/_react.default.createElement(_editor.Editor, {
    onEditorReady: onEditorReady,
    setEditorValue: val => editorValue.current = val,
    editorValue: editorValue.current,
    licenseEnabled: licenseEnabled
  })));
});