"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedPlaygroundFormProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactQuery = require("@tanstack/react-query");
var _reactHookForm = require("react-hook-form");
var _common = require("../../common");
var _use_kibana = require("../hooks/use_kibana");
var _use_load_fields_by_indices = require("../hooks/use_load_fields_by_indices");
var _use_llms_models = require("../hooks/use_llms_models");
var _types = require("../types");
var _playground_form_resolver = require("../utils/playground_form_resolver");
var _saved_playgrounds = require("../utils/saved_playgrounds");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchSavedPlayground = (playgroundId, {
  http,
  client
}) => async () => {
  let playgroundResp;
  try {
    playgroundResp = await http.get(_types.APIRoutes.GET_PLAYGROUND.replace('{id}', playgroundId), {
      version: _common.ROUTE_VERSIONS.v1
    });
  } catch (e) {
    return (0, _saved_playgrounds.fetchSavedPlaygroundError)(e);
  }
  let models;
  try {
    models = await client.fetchQuery(_use_llms_models.LLMS_QUERY_KEY, (0, _use_llms_models.LLMsQuery)(http, client));
  } catch (e) {
    models = [];
  }
  const result = (0, _saved_playgrounds.parseSavedPlayground)(playgroundResp, models);
  return result;
};
const SavedPlaygroundFormProvider = ({
  children,
  playgroundId
}) => {
  const client = (0, _reactQuery.useQueryClient)();
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const form = (0, _reactHookForm.useForm)({
    defaultValues: fetchSavedPlayground(playgroundId, {
      http,
      client
    }),
    resolver: _playground_form_resolver.savedPlaygroundFormResolver,
    reValidateMode: 'onChange',
    context: {
      http
    }
  });
  (0, _use_load_fields_by_indices.useLoadFieldsByIndices)({
    watch: form.watch,
    setValue: form.setValue,
    getValues: form.getValues
    // casting form handlers here because TS isn't happy with UseFormReturn<SavedPlaygroundForm> even though SavedPlaygroundForm extends PlaygroundForm
  });
  (0, _react.useEffect)(() => {
    if (form.formState.isLoading) return;
    // Trigger validation of existing values after initial loading.
    form.trigger();
  }, [form, form.formState.isLoading]);
  return /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, form, children);
};
exports.SavedPlaygroundFormProvider = SavedPlaygroundFormProvider;