"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useValidatePlaygroundViewModes = void 0;
var _react = require("react");
var _common = require("../../common");
var _types = require("../types");
var _use_kibana = require("./use_kibana");
var _use_playground_parameters = require("./use_playground_parameters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useValidatePlaygroundViewModes = () => {
  const {
    pageMode,
    viewMode
  } = (0, _use_playground_parameters.usePlaygroundParameters)();
  const {
    application
  } = (0, _use_kibana.useKibana)().services;
  (0, _react.useEffect)(() => {
    // Handle Unknown modes
    if (!Object.values(_types.PlaygroundPageMode).includes(pageMode)) {
      application.navigateToApp(_common.PLUGIN_ID, {
        path: '/not_found'
      });
      return;
    }
    if (!Object.values(_types.PlaygroundViewMode).includes(viewMode)) {
      application.navigateToApp(_common.PLUGIN_ID, {
        path: `/${pageMode}`
      });
    }
  }, [application, pageMode, viewMode]);
};
exports.useValidatePlaygroundViewModes = useValidatePlaygroundViewModes;