"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useQueryIndices = void 0;
var _reactQuery = require("@tanstack/react-query");
var _use_kibana = require("./use_kibana");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useQueryIndices = ({
  query,
  exact
} = {
  query: '',
  exact: false
}) => {
  const {
    services
  } = (0, _use_kibana.useKibana)();
  const {
    data,
    isLoading,
    isFetched
  } = (0, _reactQuery.useQuery)({
    queryKey: ['indices', query],
    queryFn: async () => {
      try {
        const response = await services.http.get(_types.APIRoutes.GET_INDICES, {
          query: {
            search_query: query,
            exact,
            size: 100
          }
        });
        return response.indices;
      } catch (err) {
        var _err$response;
        if ((err === null || err === void 0 ? void 0 : (_err$response = err.response) === null || _err$response === void 0 ? void 0 : _err$response.status) === 404) {
          return [];
        }
        throw err;
      }
    },
    initialData: []
  });
  return {
    indices: data,
    isLoading,
    isFetched
  };
};
exports.useQueryIndices = useQueryIndices;