"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.osquerySearchStrategyProvider = void 0;
var _rxjs = require("rxjs");
var _server = require("@kbn/data-plugin/server");
var _common = require("@kbn/data-plugin/common");
var _constants = require("../../../common/constants");
var _osquery = require("../../../common/search_strategy/osquery");
var _factory = require("./factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const osquerySearchStrategyProvider = (data, esClient) => {
  let es;
  return {
    search: (request, options, deps) => {
      if (request.factoryQueryType == null) {
        throw new Error('factoryQueryType is required');
      }
      const queryFactory = _factory.osqueryFactory[request.factoryQueryType];
      return (0, _rxjs.forkJoin)({
        actionsIndexExists: esClient.asInternalUser.indices.exists({
          index: `${_constants.ACTIONS_INDEX}*`
        }),
        newDataStreamIndexExists: esClient.asInternalUser.indices.exists({
          index: `${_constants.ACTION_RESPONSES_DATA_STREAM_INDEX}*`,
          allow_no_indices: false,
          expand_wildcards: 'all'
        })
      }).pipe((0, _rxjs.mergeMap)(({
        actionsIndexExists,
        newDataStreamIndexExists
      }) => {
        var _dsl$index, _dsl$index2;
        const strictRequest = {
          factoryQueryType: request.factoryQueryType,
          kuery: request.kuery,
          ...('pagination' in request ? {
            pagination: request.pagination
          } : {}),
          ...('sort' in request ? {
            sort: request.sort
          } : {}),
          ...('actionId' in request ? {
            actionId: request.actionId
          } : {}),
          ...('startDate' in request ? {
            startDate: request.startDate
          } : {}),
          ...('agentId' in request ? {
            agentId: request.agentId
          } : {}),
          ...('policyIds' in request ? {
            policyIds: request.policyIds
          } : {}),
          ...('spaceId' in request ? {
            spaceId: request.spaceId
          } : {})
        };
        const dsl = queryFactory.buildDsl({
          ...strictRequest,
          componentTemplateExists: actionsIndexExists
        });

        // use internal user for searching .fleet* indices
        es = (_dsl$index = dsl.index) !== null && _dsl$index !== void 0 && _dsl$index.includes('fleet') || (_dsl$index2 = dsl.index) !== null && _dsl$index2 !== void 0 && _dsl$index2.includes('logs-osquery_manager.action') ? data.search.searchAsInternalUser : data.search.getSearchStrategy(_common.ENHANCED_ES_SEARCH_STRATEGY);
        const searchLegacyIndex$ = es.search({
          ...strictRequest,
          params: dsl
        }, options, deps);

        // With the introduction of a new DS that sends data directly from an agent into the new index
        // logs-osquery_manager.action.responses-default, instead of the old index .logs-osquery_manager.action.responses-default
        // which was populated by a transform, we now need to check both places for results.
        // The new index was introduced in integration package 1.12, so users running earlier versions won't have it.

        return searchLegacyIndex$.pipe((0, _rxjs.mergeMap)(legacyIndexResponse => {
          if (request.factoryQueryType === _osquery.OsqueryQueries.actionResults && newDataStreamIndexExists) {
            const dataStreamDsl = queryFactory.buildDsl({
              ...strictRequest,
              componentTemplateExists: actionsIndexExists,
              useNewDataStream: true
            });
            return (0, _rxjs.from)(es.search({
              ...strictRequest,
              params: dataStreamDsl
            }, options, deps)).pipe((0, _rxjs.map)(newDataStreamIndexResponse => {
              if (newDataStreamIndexResponse.rawResponse.hits.total) {
                return newDataStreamIndexResponse;
              }
              return legacyIndexResponse;
            }));
          }
          return (0, _rxjs.of)(legacyIndexResponse);
        }), (0, _rxjs.map)(response => ({
          ...response,
          ...{
            rawResponse: (0, _server.shimHitsTotal)(response.rawResponse, options)
          },
          total: response.rawResponse.hits.total
        })), (0, _rxjs.mergeMap)(esSearchRes => queryFactory.parse(request, esSearchRes)));
      }));
    },
    cancel: async (id, options, deps) => {
      var _es;
      if ((_es = es) !== null && _es !== void 0 && _es.cancel) {
        return es.cancel(id, options, deps);
      }
    }
  };
};
exports.osquerySearchStrategyProvider = osquerySearchStrategyProvider;