"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createScopedRunner = exports.createRunner = exports.RunnerManager = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _onechatCommon = require("@kbn/onechat-common");
var _run_context = require("./utils/run_context");
var _run_tool = require("./run_tool");
var _run_agent = require("./run_agent");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RunnerManager {
  constructor(deps, context) {
    (0, _defineProperty2.default)(this, "deps", void 0);
    (0, _defineProperty2.default)(this, "context", void 0);
    // arrow function is required, risks of loosing context when passed down as handler.
    (0, _defineProperty2.default)(this, "getRunner", () => {
      return {
        runTool: toolExecutionParams => {
          try {
            return (0, _run_tool.runTool)({
              toolExecutionParams,
              parentManager: this
            });
          } catch (e) {
            if ((0, _onechatCommon.isOnechatError)(e)) {
              throw e;
            } else {
              throw (0, _onechatCommon.createInternalError)(e.message);
            }
          }
        },
        runAgent: agentExecutionParams => {
          try {
            return (0, _run_agent.runAgent)({
              agentExecutionParams,
              parentManager: this
            });
          } catch (e) {
            if ((0, _onechatCommon.isOnechatError)(e)) {
              throw e;
            } else {
              throw (0, _onechatCommon.createInternalError)(e.message);
            }
          }
        }
      };
    });
    this.deps = deps;
    this.context = context !== null && context !== void 0 ? context : (0, _run_context.createEmptyRunContext)();
  }
  createChild(childContext) {
    return new RunnerManager(this.deps, childContext);
  }
}
exports.RunnerManager = RunnerManager;
const createScopedRunner = deps => {
  const manager = new RunnerManager(deps, (0, _run_context.createEmptyRunContext)());
  return manager.getRunner();
};
exports.createScopedRunner = createScopedRunner;
const createRunner = deps => {
  return {
    runTool: runToolParams => {
      const {
        request,
        defaultConnectorId,
        ...otherParams
      } = runToolParams;
      const allDeps = {
        ...deps,
        request,
        defaultConnectorId
      };
      const runner = createScopedRunner(allDeps);
      return runner.runTool(otherParams);
    },
    runAgent: params => {
      const {
        request,
        defaultConnectorId,
        ...otherParams
      } = params;
      const allDeps = {
        ...deps,
        request,
        defaultConnectorId
      };
      const runner = createScopedRunner(allDeps);
      return runner.runAgent(otherParams);
    }
  };
};
exports.createRunner = createRunner;