"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceManager = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _tools = require("./tools");
var _agents = require("./agents");
var _runner = require("./runner");
var _conversation = require("./conversation");
var _chat = require("./chat");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ServiceManager {
  constructor() {
    (0, _defineProperty2.default)(this, "services", void 0);
    (0, _defineProperty2.default)(this, "internalSetup", void 0);
    (0, _defineProperty2.default)(this, "internalStart", void 0);
  }
  setupServices({
    logger
  }) {
    this.services = {
      tools: new _tools.ToolsService(),
      agents: new _agents.AgentsService()
    };
    this.internalSetup = {
      tools: this.services.tools.setup(),
      agents: this.services.agents.setup({
        logger
      })
    };
    return this.internalSetup;
  }
  startServices({
    logger,
    security,
    elasticsearch,
    actions,
    inference
  }) {
    if (!this.services) {
      throw new Error('#startServices called before #setupServices');
    }

    // eslint-disable-next-line prefer-const
    let runner;
    const getRunner = () => {
      if (!runner) {
        throw new Error('Trying to access runner before initialization');
      }
      return runner;
    };
    const tools = this.services.tools.start({
      getRunner
    });
    const agents = this.services.agents.start({
      getRunner
    });
    const runnerFactory = new _runner.RunnerFactoryImpl({
      logger: logger.get('runnerFactory'),
      security,
      elasticsearch,
      actions,
      inference,
      toolsService: tools,
      agentsService: agents
    });
    runner = runnerFactory.getRunner();
    const conversations = new _conversation.ConversationServiceImpl({
      logger: logger.get('conversations'),
      security,
      elasticsearch
    });
    const chat = (0, _chat.createChatService)({
      logger: logger.get('chat'),
      actions,
      inference,
      conversationService: conversations,
      agentService: agents
    });
    this.internalStart = {
      tools,
      agents,
      conversations,
      runnerFactory,
      chat
    };
    return this.internalStart;
  }
}
exports.ServiceManager = ServiceManager;