"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unwrapOnechatErrors = unwrapOnechatErrors;
var _rxjs = require("rxjs");
var _sseUtils = require("@kbn/sse-utils");
var _onechatCommon = require("@kbn/onechat-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Convert SSE errors to Onechat errors and rethrow them.
 */
function unwrapOnechatErrors() {
  return (0, _rxjs.catchError)(err => {
    if ((0, _sseUtils.isSSEError)(err)) {
      return (0, _rxjs.throwError)(() => (0, _onechatCommon.createOnechatError)(err.code, err.message, err.meta));
    }
    return (0, _rxjs.throwError)(() => err);
  });
}