"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnechatRoutes = void 0;
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _tools = require("./pages/tools");
var _chat = require("./pages/chat");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OnechatRoutes = () => {
  const isToolsPageEnabled = (0, _public.useUiSetting)(_constants.ONECHAT_TOOLS_UI_SETTING_ID, false);
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/conversations"
  }, /*#__PURE__*/_react.default.createElement(_chat.OnechatConversationsPage, null)), isToolsPageEnabled && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/tools"
  }, /*#__PURE__*/_react.default.createElement(_tools.OnechatToolsPage, null)));
};
exports.OnechatRoutes = OnechatRoutes;