"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.naturalLanguageSearch = void 0;
var _execute_esql = require("./steps/execute_esql");
var _generate_esql = require("./generate_esql");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const naturalLanguageSearch = async ({
  query,
  context,
  index,
  model,
  esClient
}) => {
  const generateResponse = await (0, _generate_esql.generateEsql)({
    query,
    context,
    index,
    model,
    esClient
  });
  if (generateResponse.queries.length < 1) {
    return {
      success: false,
      reason: 'No query was generated'
    };
  }
  return await (0, _execute_esql.executeEsql)({
    query: generateResponse.queries[0],
    esClient
  });
};
exports.naturalLanguageSearch = naturalLanguageSearch;