"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchAnnotations = useFetchAnnotations;
var _reactQuery = require("@tanstack/react-query");
var _kibana_react = require("../../../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchAnnotations({
  start,
  end,
  slo
}) {
  const {
    http
  } = (0, _kibana_react.useKibana)().services;
  const sloId = slo === null || slo === void 0 ? void 0 : slo.id;
  const sloInstanceId = slo === null || slo === void 0 ? void 0 : slo.instanceId;
  let serviceName;
  if (slo !== null && slo !== void 0 && slo.indicator.params && 'service' in (slo === null || slo === void 0 ? void 0 : slo.indicator.params)) {
    serviceName = slo === null || slo === void 0 ? void 0 : slo.indicator.params.service;
  }
  const {
    isLoading,
    isError,
    isSuccess,
    data,
    refetch
  } = (0, _reactQuery.useQuery)({
    queryKey: ['fetchAnnotationList', start, end, sloId, sloInstanceId, serviceName],
    queryFn: async ({}) => {
      return await http.get('/api/observability/annotation/find', {
        query: {
          start,
          end,
          serviceName,
          sloId,
          sloInstanceId
        }
      });
    },
    refetchOnWindowFocus: false,
    keepPreviousData: true
  });
  return {
    data,
    isLoading,
    isSuccess,
    isError,
    refetch
  };
}