"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageTemplate = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _footer = require("../footer/footer");
var _header = require("../header");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PageTemplate = ({
  children,
  customHeader
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPageTemplate, {
    css: (0, _react.css)`
        padding-top: 0px !important;
      `
  }, !!customHeader ? customHeader : /*#__PURE__*/_react2.default.createElement(_header.Header, null), /*#__PURE__*/_react2.default.createElement(_eui.EuiPageTemplate.Section, {
    paddingSize: "xl",
    color: "subdued",
    restrictWidth: true
  }, children), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiPageTemplate.Section, {
    contentProps: {
      css: {
        paddingBlock: 0
      }
    },
    css: (0, _react.css)`
          padding-inline: 0px;
          border-top: ${euiTheme.border.thin};
        `
  }, /*#__PURE__*/_react2.default.createElement(_footer.Footer, null)));
};
exports.PageTemplate = PageTemplate;