"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShardAllocation = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _cluster_view = require("./components/cluster_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const clusterStyle = ({
  euiTheme
}) => (0, _react2.css)`
  th {
    text-align: left;
  }

  td:first-child {
    width: calc(${euiTheme.base} * 12.5);
  }
`;
const ShardAllocation = props => {
  const types = [{
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.shardAllocation.primaryLabel', {
      defaultMessage: 'Primary'
    }),
    color: 'primary'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.shardAllocation.replicaLabel', {
      defaultMessage: 'Replica'
    }),
    color: 'success'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.shardAllocation.relocatingLabel', {
      defaultMessage: 'Relocating'
    }),
    color: 'accent'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.shardAllocation.initializingLabel', {
      defaultMessage: 'Initializing'
    }),
    color: 'default'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.shardAllocation.unassignedPrimaryLabel', {
      defaultMessage: 'Unassigned Primary'
    }),
    color: 'danger'
  }, {
    label: _i18n.i18n.translate('xpack.monitoring.elasticsearch.shardAllocation.unassignedReplicaLabel', {
      defaultMessage: 'Unassigned Replica'
    }),
    color: 'warning'
  }];
  return /*#__PURE__*/_react.default.createElement("div", {
    css: clusterStyle
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.elasticsearch.shardAllocation.shardLegendTitle",
    defaultMessage: "Shard Legend"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    responsive: false,
    gutterSize: "s"
  }, types.map(type => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: type.label
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: type.color
  }, type.label)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_cluster_view.ClusterView, props));
};
exports.ShardAllocation = ShardAllocation;