"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTextExpansionOutputComponent = exports.TextExpansionOutput = exports.DocumentResultWithTokens = exports.DocumentResult = void 0;
var _react = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
var _mlNumberUtils = require("@kbn/ml-number-utils");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_TOKENS = 5;
const getTextExpansionOutputComponent = inferrer => /*#__PURE__*/_react.default.createElement(TextExpansionOutput, {
  inferrer: inferrer
});
exports.getTextExpansionOutputComponent = getTextExpansionOutputComponent;
const TextExpansionOutput = ({
  inferrer
}) => {
  const result = (0, _useObservable.default)(inferrer.getInferenceResult$(), inferrer.getInferenceResult());
  if (!result) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "primary"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.testModelsFlyout.textExpansion.output.info",
    defaultMessage: "The numbers below represent relevance scores for documents randomly selected from the index concerning the supplied query. Evaluating model recall is simpler when using a query related to the documents."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), result.sort((a, b) => b.response.score - a.response.score).map(({
    response,
    inputText
  }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(DocumentResult, {
    response: response
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null))));
};
exports.TextExpansionOutput = TextExpansionOutput;
const DocumentResult = ({
  response
}) => {
  const statInfo = useResultStatFormatting(response);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, response.text !== undefined ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: (0, _mlNumberUtils.roundToDecimalPlace)(response.score, 3),
    textAlign: "left",
    titleColor: statInfo.color,
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: statInfo.color
    }, /*#__PURE__*/_react.default.createElement("span", null, statInfo.icon !== null ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: statInfo.icon,
      color: statInfo.color
    }) : null, statInfo.text))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("span", {
    css: {
      color: statInfo.textColor
    }
  }, response.text), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })) : null);
};

/*
 * Currently not used. Tokens could contain sensitive words, so need to be hidden from the user.
 * This may change in the future, in which case this function will be used.
 */
exports.DocumentResult = DocumentResult;
const DocumentResultWithTokens = ({
  response
}) => {
  const tokens = response.adjustedTokenWeights.filter(({
    value
  }) => value > 0).sort((a, b) => b.value - a.value).slice(0, MAX_TOKENS).map(({
    token,
    value
  }) => ({
    token,
    value: (0, _mlNumberUtils.roundToDecimalPlace)(value, 3)
  }));
  const statInfo = useResultStatFormatting(response);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, response.text !== undefined ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: (0, _mlNumberUtils.roundToDecimalPlace)(response.score, 3),
    textAlign: "left",
    titleColor: statInfo.color,
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: statInfo.color
    }, /*#__PURE__*/_react.default.createElement("span", null, statInfo.icon !== null ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: statInfo.icon,
      color: statInfo.color
    }) : null, statInfo.text))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("span", {
    css: {
      color: statInfo.textColor
    }
  }, response.text), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })) : null, tokens.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: `textExpansion_${response.text}`,
    buttonContent: _i18n.i18n.translate('xpack.ml.trainedModels.testModelsFlyout.textExpansion.output.tokens', {
      defaultMessage: 'Tokens'
    })
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "primary"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.testModelsFlyout.textExpansion.output.tokenHelpInfo",
    defaultMessage: "Top {count} extracted tokens, which are not synonyms of the query, represent linguistic elements relevant to the search result. The weight value represents the relevancy of a given token.",
    values: {
      count: MAX_TOKENS
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: tokens,
    columns: [{
      field: 'token',
      name: _i18n.i18n.translate('xpack.ml.trainedModels.testModelsFlyout.textExpansion.output.token', {
        defaultMessage: 'Token'
      })
    }, {
      field: 'value',
      name: _i18n.i18n.translate('xpack.ml.trainedModels.testModelsFlyout.textExpansion.output.weight', {
        defaultMessage: 'Weight'
      })
    }]
  }))) : null);
};
exports.DocumentResultWithTokens = DocumentResultWithTokens;
const useResultStatFormatting = response => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (response.score >= 5) {
    return {
      color: 'success',
      textColor: euiTheme.colors.textParagraph,
      icon: 'check',
      text: _i18n.i18n.translate('xpack.ml.trainedModels.testModelsFlyout.textExpansion.output.goodMatch', {
        defaultMessage: 'Good match'
      })
    };
  }
  if (response.score > 0) {
    return {
      color: euiTheme.colors.textSubdued,
      textColor: euiTheme.colors.textParagraph,
      text: null,
      icon: null
    };
  }
  return {
    color: euiTheme.colors.mediumShade,
    textColor: euiTheme.colors.mediumShade,
    text: null,
    icon: null
  };
};