"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stopActionNameText = exports.StopActionName = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _check_capabilities = require("../../../../../capabilities/check_capabilities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const stopActionNameText = exports.stopActionNameText = _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.stopActionNameText', {
  defaultMessage: 'Stop'
});
const StopActionName = ({
  isDisabled
}) => {
  if (isDisabled) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: (0, _check_capabilities.createPermissionFailureMessage)('canStartStopDataFrameAnalytics')
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0
    }, stopActionNameText));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, stopActionNameText);
};
exports.StopActionName = StopActionName;