"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cpu = void 0;
var _constants = require("../../../shared/charts/constants");
var _formulas = require("../formulas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dockerContainerCpuUsageXY = {
  id: 'cpuUsage',
  chartType: 'xy',
  title: _constants.CPU_USAGE_LABEL,
  layers: [{
    seriesType: 'line',
    type: 'series',
    xAxis: '@timestamp',
    yAxis: [_formulas.formulas.dockerContainerCpuUsage]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_HIDDEN_LEGEND,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE,
  ..._constants.DEFAULT_XY_YBOUNDS
};
const k8sContainerCpuUsageXY = {
  id: 'k8sCpuUsage',
  chartType: 'xy',
  title: _constants.CPU_USAGE_LABEL,
  layers: [{
    seriesType: 'line',
    type: 'series',
    xAxis: '@timestamp',
    yAxis: [_formulas.formulas.k8sContainerCpuUsage]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_HIDDEN_LEGEND,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE,
  ..._constants.DEFAULT_XY_YBOUNDS
};
const dockerContainerCpuUsageMetric = {
  id: 'cpuUsage',
  chartType: 'metric',
  title: _constants.CPU_USAGE_LABEL,
  trendLine: true,
  ..._formulas.formulas.dockerContainerCpuUsage
};
const containerK8sCpuUsageMetric = {
  id: 'k8sCpuUsage',
  chartType: 'metric',
  title: _constants.CPU_USAGE_LABEL,
  trendLine: true,
  ..._formulas.formulas.k8sContainerCpuUsage
};
const cpu = exports.cpu = {
  xy: {
    dockerContainerCpuUsage: dockerContainerCpuUsageXY,
    k8sContainerCpuUsage: k8sContainerCpuUsageXY
  },
  metric: {
    dockerContainerCpuUsage: dockerContainerCpuUsageMetric,
    k8sContainerCpuUsage: containerK8sCpuUsageMetric
  }
};