"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.managementSections = exports.StackSection = exports.SecuritySection = exports.MachineLearningSection = exports.KibanaSection = exports.InsightsAndAlertingSection = exports.IngestSection = exports.DataSection = void 0;
var _i18n = require("@kbn/i18n");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ingestTitle = _i18n.i18n.translate('management.sections.ingestTitle', {
  defaultMessage: 'Ingest'
});
const ingestTip = _i18n.i18n.translate('management.sections.ingestTip', {
  defaultMessage: 'Manage how to transform data and load it into the cluster'
});
const dataTitle = _i18n.i18n.translate('management.sections.dataTitle', {
  defaultMessage: 'Data'
});
const dataTip = _i18n.i18n.translate('management.sections.dataTip', {
  defaultMessage: 'Manage your cluster data and backups'
});
const insightsAndAlertingTitle = _i18n.i18n.translate('management.sections.insightsAndAlertingTitle', {
  defaultMessage: 'Alerts and Insights'
});
const insightsAndAlertingTip = _i18n.i18n.translate('management.sections.insightsAndAlertingTip', {
  defaultMessage: 'Manage how to detect changes in your data'
});
const machineLearningTitle = _i18n.i18n.translate('management.sections.machineLearningTitle', {
  defaultMessage: 'Machine Learning'
});
const machineLearningTip = _i18n.i18n.translate('management.sections.machineLearningTip', {
  defaultMessage: 'Manage your Machine Learning jobs and trained models'
});
const sectionTitle = _i18n.i18n.translate('management.sections.section.title', {
  defaultMessage: 'Security'
});
const sectionTip = _i18n.i18n.translate('management.sections.section.tip', {
  defaultMessage: 'Control access to features and data'
});
const kibanaTitle = _i18n.i18n.translate('management.sections.kibanaTitle', {
  defaultMessage: 'Kibana'
});
const kibanaTip = _i18n.i18n.translate('management.sections.kibanaTip', {
  defaultMessage: 'Customize Kibana and manage saved objects'
});
const stackTitle = _i18n.i18n.translate('management.sections.stackTitle', {
  defaultMessage: 'Stack'
});
const stackTip = _i18n.i18n.translate('management.sections.stackTip', {
  defaultMessage: 'Manage your license and upgrade the Stack'
});
const IngestSection = exports.IngestSection = {
  id: _types.ManagementSectionId.Ingest,
  title: ingestTitle,
  tip: ingestTip,
  order: 0
};
const DataSection = exports.DataSection = {
  id: _types.ManagementSectionId.Data,
  title: dataTitle,
  tip: dataTip,
  order: 1
};
const InsightsAndAlertingSection = exports.InsightsAndAlertingSection = {
  id: _types.ManagementSectionId.InsightsAndAlerting,
  title: insightsAndAlertingTitle,
  tip: insightsAndAlertingTip,
  order: 2
};
const MachineLearningSection = exports.MachineLearningSection = {
  id: _types.ManagementSectionId.MachineLearning,
  title: machineLearningTitle,
  tip: machineLearningTip,
  order: 4
};
const SecuritySection = exports.SecuritySection = {
  id: 'security',
  title: sectionTitle,
  tip: sectionTip,
  order: 3
};
const KibanaSection = exports.KibanaSection = {
  id: _types.ManagementSectionId.Kibana,
  title: kibanaTitle,
  tip: kibanaTip,
  order: 4
};
const StackSection = exports.StackSection = {
  id: _types.ManagementSectionId.Stack,
  title: stackTitle,
  tip: stackTip,
  order: 4
};
const managementSections = exports.managementSections = [IngestSection, DataSection, InsightsAndAlertingSection, MachineLearningSection, SecuritySection, KibanaSection, StackSection];