"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PalettePreview = void 0;
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _get_color_palette = require("../../lib/get_color_palette");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PalettePreview = ({
  steps,
  palette,
  reverse
}) => {
  const colors = (0, _get_color_palette.getColorPalette)(palette, steps, reverse);
  return /*#__PURE__*/_react.default.createElement(Swatches, null, colors.map(color => /*#__PURE__*/_react.default.createElement(Swatch, {
    key: color,
    style: {
      backgroundColor: color
    }
  })));
};
exports.PalettePreview = PalettePreview;
const Swatch = _styled.default.div`
  max-width: 15px;
  height: 12px;
  flex: 1 1 auto;
  &:first-child {
    border-radius: ${props => props.theme.euiTheme.border.radius} 0 0 ${props => props.theme.euiTheme.border.radius};
  }
  &:last-child {
    border-radius: 0 ${props => props.theme.euiTheme.border.radius} ${props => props.theme.euiTheme.border.radius} 0;
`;
const Swatches = _styled.default.div`
  display: flex;
`;