"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogEntryCategoryExamples = void 0;
var _react = require("react");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_tracked_promise = require("../../../hooks/use_tracked_promise");
var _get_log_entry_category_examples = require("./service_calls/get_log_entry_category_examples");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogEntryCategoryExamples = ({
  categoryId,
  endTime,
  exampleCount,
  logViewReference,
  idFormat,
  startTime
}) => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const [logEntryCategoryExamples, setLogEntryCategoryExamples] = (0, _react.useState)([]);
  const [getLogEntryCategoryExamplesRequest, getLogEntryCategoryExamples] = (0, _use_tracked_promise.useTrackedPromise)({
    cancelPreviousOn: 'creation',
    createPromise: async () => {
      if (!idFormat) {
        throw new Error('idFormat is undefined');
      }
      return await (0, _get_log_entry_category_examples.callGetLogEntryCategoryExamplesAPI)({
        logViewReference,
        idFormat,
        startTime,
        endTime,
        categoryId,
        exampleCount
      }, services.http.fetch);
    },
    onResolve: ({
      data: {
        examples
      }
    }) => {
      setLogEntryCategoryExamples(examples);
    }
  }, [categoryId, endTime, exampleCount, logViewReference, startTime, idFormat]);
  const isLoadingLogEntryCategoryExamples = (0, _react.useMemo)(() => getLogEntryCategoryExamplesRequest.state === 'pending', [getLogEntryCategoryExamplesRequest.state]);
  const hasFailedLoadingLogEntryCategoryExamples = (0, _react.useMemo)(() => getLogEntryCategoryExamplesRequest.state === 'rejected', [getLogEntryCategoryExamplesRequest.state]);
  return {
    getLogEntryCategoryExamples,
    hasFailedLoadingLogEntryCategoryExamples,
    isLoadingLogEntryCategoryExamples,
    logEntryCategoryExamples
  };
};
exports.useLogEntryCategoryExamples = useLogEntryCategoryExamples;