"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadingPrompt = exports.LoadingPage = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _page_template = require("./page_template");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Represents a fully constructed page, including page template.
const LoadingPage = ({
  message,
  'data-test-subj': dataTestSubj = 'loadingPage'
}) => {
  return /*#__PURE__*/_react.default.createElement(_page_template.PageTemplate, {
    isEmptyState: true,
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(LoadingPrompt, {
    message: message
  }));
};
exports.LoadingPage = LoadingPage;
const LoadingPrompt = ({
  message
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl",
      style: {
        marginRight: '8px'
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, message))
  });
};
exports.LoadingPrompt = LoadingPrompt;