"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reloadIndicesSuccess = exports.reloadIndices = void 0;
var _reduxActions = require("redux-actions");
var _i18n = require("@kbn/i18n");
var _services = require("../../services");
var _load_indices = require("./load_indices");
var _notification = require("../../services/notification");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const reloadIndicesSuccess = exports.reloadIndicesSuccess = (0, _reduxActions.createAction)('INDEX_MANAGEMENT_RELOAD_INDICES_SUCCESS');
const reloadIndices = (indexNames, options) => async dispatch => {
  let indices;
  try {
    indices = await (0, _services.reloadIndices)(indexNames, options);
  } catch (error) {
    // an index has been deleted
    // or the user does not have privileges for one of the indices on the current page,
    // reload the full list
    if (error.status === 404 || error.status === 403) {
      return dispatch((0, _load_indices.loadIndices)());
    }
    return _notification.notificationService.showDangerToast(error.body.message);
  }
  if (indices && indices.length > 0) {
    return dispatch(reloadIndicesSuccess({
      indices
    }));
  } else {
    return _notification.notificationService.showWarningToast(_i18n.i18n.translate('xpack.idxMgmt.reloadIndicesAction.indicesPageRefreshFailureMessage', {
      defaultMessage: 'Failed to refresh current page of indices.'
    }));
  }
};
exports.reloadIndices = reloadIndices;