"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteDataStreamConfirmationModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _api = require("../../../../services/api");
var _notification = require("../../../../services/notification");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteDataStreamConfirmationModal = ({
  dataStreams,
  onClose
}) => {
  const [isLoading, setLoading] = (0, _react.useState)(false);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const dataStreamsCount = dataStreams.length;
  const handleDeleteDataStreams = () => {
    setLoading(true);
    (0, _api.deleteDataStreams)(dataStreams).then(({
      data: {
        dataStreamsDeleted,
        errors
      },
      error
    }) => {
      const hasDeletedDataStreams = dataStreamsDeleted && dataStreamsDeleted.length;
      if (hasDeletedDataStreams) {
        const successMessage = dataStreamsDeleted.length === 1 ? _i18n.i18n.translate('xpack.idxMgmt.deleteDataStreamsConfirmationModal.successDeleteSingleNotificationMessageText', {
          defaultMessage: "Deleted data stream ''{dataStreamName}''",
          values: {
            dataStreamName: dataStreams[0]
          }
        }) : _i18n.i18n.translate('xpack.idxMgmt.deleteDataStreamsConfirmationModal.successDeleteMultipleNotificationMessageText', {
          defaultMessage: 'Deleted {numSuccesses, plural, one {# data stream} other {# data streams}}',
          values: {
            numSuccesses: dataStreamsDeleted.length
          }
        });
        onClose({
          hasDeletedDataStreams
        });
        _notification.notificationService.showSuccessToast(successMessage);
      }
      if (error || errors && errors.length) {
        const hasMultipleErrors = errors && errors.length > 1 || error && dataStreams.length > 1;
        const errorMessage = hasMultipleErrors ? _i18n.i18n.translate('xpack.idxMgmt.deleteDataStreamsConfirmationModal.multipleErrorsNotificationMessageText', {
          defaultMessage: 'Error deleting {count} data streams',
          values: {
            count: errors && errors.length || dataStreams.length
          }
        }) : _i18n.i18n.translate('xpack.idxMgmt.deleteDataStreamsConfirmationModal.errorNotificationMessageText', {
          defaultMessage: "Error deleting data stream ''{name}''",
          values: {
            name: errors && errors[0].name || dataStreams[0]
          }
        });
        _notification.notificationService.showDangerToast(errorMessage);
      }
    }).finally(() => setLoading(false));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    buttonColor: "danger",
    "data-test-subj": "deleteDataStreamsConfirmation",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.deleteDataStreamsConfirmationModal.modalTitleText",
      defaultMessage: "Delete {dataStreamsCount, plural, one {data stream} other {# data streams}}",
      values: {
        dataStreamsCount
      }
    }),
    onCancel: () => onClose(),
    onConfirm: handleDeleteDataStreams,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.deleteDataStreamsConfirmationModal.cancelButtonLabel",
      defaultMessage: "Cancel"
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.deleteDataStreamsConfirmationModal.confirmButtonLabel",
      defaultMessage: "Delete {dataStreamsCount, plural, one {data stream} other {data streams} }",
      values: {
        dataStreamsCount
      }
    }),
    isLoading: isLoading
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.deleteDataStreamsConfirmationModal.warningTitle",
      defaultMessage: "Deleting data streams also deletes indices"
    }),
    color: "danger",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.deleteDataStreamsConfirmationModal.warningMessage",
    defaultMessage: "Data streams are collections of time series indices. Deleting a data stream will also delete its indices."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.deleteDataStreamsConfirmationModal.deleteDescription",
    defaultMessage: "You are about to delete {dataStreamsCount, plural, one {this data stream} other {these data streams} }:",
    values: {
      dataStreamsCount
    }
  })), /*#__PURE__*/_react.default.createElement("ul", null, dataStreams.map(name => /*#__PURE__*/_react.default.createElement("li", {
    key: name
  }, name)))));
};
exports.DeleteDataStreamConfirmationModal = DeleteDataStreamConfirmationModal;