/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(self.grokdebugger_bundle_jsonpfunction=self.grokdebugger_bundle_jsonpfunction||[]).push([[749],{749:(e,t,s)=>{"use strict";s.d(t,{renderApp:()=>C});var r=s(286),a=s.n(r),n=s(874),i=s(409),u=s(482),o=s(915),g=s(8),l=s(770),c=s(319),d=s(879),p=s(424),m=s(791);function b({value:e,onChange:t}){return(0,m.jsx)(c.EuiFormRow,{label:(0,m.jsx)(d.FormattedMessage,{id:"xpack.grokDebugger.sampleDataLabel",defaultMessage:"Sample Data"}),fullWidth:!0,"data-test-subj":"eventInput"},(0,m.jsx)(p.CodeEditor,{languageId:"plaintext",value:e,height:200,options:{tabSize:2,automaticLayout:!0},"aria-label":g.i18n.translate("xpack.grokDebugger.eventInputEditor",{defaultMessage:"Code editor for event inputs"}),onChange:t}))}function h({value:e,onChange:t}){return(0,m.jsx)(c.EuiFormRow,{label:(0,m.jsx)(d.FormattedMessage,{id:"xpack.grokDebugger.grokPatternLabel",defaultMessage:"Grok Pattern"}),fullWidth:!0,"data-test-subj":"patternInput"},(0,m.jsx)(p.CodeEditor,{languageId:p.GROK_LANG_ID,value:e,height:200,options:{tabSize:2,automaticLayout:!0},"aria-label":g.i18n.translate("xpack.grokDebugger.grokPatternAriaLabel",{defaultMessage:"Code editor for inputting the grok pattern"}),onChange:t}))}function k({value:e,onChange:t}){return(0,m.jsx)(c.EuiAccordion,{id:"customPatternsInput",buttonContent:(0,m.jsx)(d.FormattedMessage,{id:"xpack.grokDebugger.customPatternsButtonLabel",defaultMessage:"Custom Patterns"}),"data-test-subj":"btnToggleCustomPatternsInput"},(0,m.jsx)(c.EuiSpacer,{size:"m"}),(0,m.jsx)(c.EuiCallOut,{title:(0,m.jsx)(d.FormattedMessage,{id:"xpack.grokDebugger.customPatterns.callOutTitle",defaultMessage:"Enter one custom pattern per line. For example:"})},(0,m.jsx)(c.EuiCodeBlock,null,"POSTFIX_QUEUEID [0-9A-F]{10,11}\nMSG message-id=<%{GREEDYDATA}>")),(0,m.jsx)(c.EuiSpacer,{size:"m"}),(0,m.jsx)(c.EuiFormRow,{fullWidth:!0,"data-test-subj":"aceCustomPatternsInput"},(0,m.jsx)(p.CodeEditor,{languageId:"plaintext",value:e,height:200,options:{tabSize:2,automaticLayout:!0},"aria-label":g.i18n.translate("xpack.grokDebugger.customPatternsInput",{defaultMessage:"Code editor for inputting custom patterns"}),onChange:t})))}function x({value:e}){return(0,m.jsx)(c.EuiFormRow,{label:(0,m.jsx)(d.FormattedMessage,{id:"xpack.grokDebugger.structuredDataLabel",defaultMessage:"Structured Data"}),fullWidth:!0},(0,m.jsx)(c.EuiCodeBlock,{paddingSize:"m",language:"json",isCopyable:!0,"data-test-subj":"eventOutputCodeBlock"},JSON.stringify(e,null,2)))}class GrokdebuggerRequest{constructor(e={}){this.rawEvent=(0,l.get)(e,"rawEvent",""),this.pattern=(0,l.get)(e,"pattern",""),this.customPatterns=(0,l.get)(e,"customPatterns",{})}get upstreamJSON(){return(0,l.pick)(this,["rawEvent","pattern","customPatterns"])}}const E={simulate:{errorTitle:g.i18n.translate("xpack.grokDebugger.simulate.errorTitle",{defaultMessage:"Simulate error"}),unknownErrorTitle:g.i18n.translate("xpack.grokDebugger.unknownErrorTitle",{defaultMessage:"Something went wrong"})}};class GrokDebuggerComponent extends a().Component{constructor(e){super(e),(0,o.default)(this,"onRawEventChange",(e=>{this.setState({rawEvent:e}),this.grokdebuggerRequest.rawEvent=e.trimEnd()})),(0,o.default)(this,"onPatternChange",(e=>{this.setState({pattern:e}),this.grokdebuggerRequest.pattern=e.trimEnd()})),(0,o.default)(this,"onCustomPatternsChange",(e=>{this.setState({customPatterns:e}),e=e.trim();const t={};e?(e.split("\n").forEach((e=>{const[,s,r]=e.match(/(\S+)\s+(.+)/)||[];s&&r&&(t[s]=r)})),this.grokdebuggerRequest.customPatterns=t):this.grokdebuggerRequest.customPatterns=t})),(0,o.default)(this,"simulateGrok",(async()=>{const e=this.props.kibana.services.notifications;try{const t=await this.props.grokdebuggerService.simulate(this.grokdebuggerRequest);this.setState({structuredEvent:t.structuredEvent}),(0,l.isEmpty)(t.error)||e.toasts.addDanger({title:E.simulate.errorTitle,text:t.error})}catch(t){e.toasts.addError(t,{title:E.simulate.unknownErrorTitle})}})),(0,o.default)(this,"onSimulateClick",(()=>{this.setState({structuredEvent:{}},this.simulateGrok)})),(0,o.default)(this,"isSimulateDisabled",(()=>""===this.state.rawEvent.trim()||""===this.state.pattern.trim())),this.state={rawEvent:"",pattern:"",customPatterns:"",structuredEvent:{}},this.grokdebuggerRequest=new GrokdebuggerRequest}render(){return(0,m.jsx)(c.EuiPage,null,(0,m.jsx)(c.EuiPageBody,null,(0,m.jsx)(c.EuiPageSection,{grow:!0,color:"plain"},(0,m.jsx)(c.EuiForm,{className:"grokdebugger-container","data-test-subj":"grokDebuggerContainer"},(0,m.jsx)(b,{value:this.state.rawEvent,onChange:this.onRawEventChange}),(0,m.jsx)(h,{value:this.state.pattern,onChange:this.onPatternChange}),(0,m.jsx)(c.EuiSpacer,null),(0,m.jsx)(k,{value:this.state.customPatterns,onChange:this.onCustomPatternsChange}),(0,m.jsx)(c.EuiSpacer,null),(0,m.jsx)(c.EuiButton,{fill:!0,onClick:this.onSimulateClick,isDisabled:this.isSimulateDisabled(),"data-test-subj":"btnSimulate"},(0,m.jsx)(d.FormattedMessage,{id:"xpack.grokDebugger.simulateButtonLabel",defaultMessage:"Simulate"})),(0,m.jsx)(c.EuiSpacer,null),(0,m.jsx)(x,{value:this.state.structuredEvent})))))}}const j=(0,i.withKibana)(GrokDebuggerComponent);var f=s(905);class GrokdebuggerResponse{constructor(e){this.structuredEvent=(0,l.get)(e,"structuredEvent",{}),this.error=(0,l.get)(e,"error",{})}static fromUpstreamJSON(e){return new GrokdebuggerResponse(e)}}class GrokdebuggerService{constructor(e){this.http=e}simulate(e){return this.http.post(`${f.bw.API_ROOT}/simulate`,{body:JSON.stringify(e.upstreamJSON)}).then((e=>GrokdebuggerResponse.fromUpstreamJSON(e))).catch((e=>{throw new Error(e.body.message)}))}}const v=()=>{const e=g.i18n.translate("xpack.grokDebugger.registerLicenseLinkLabel",{defaultMessage:"register a license"}),t=g.i18n.translate("xpack.grokDebugger.trialLicenseTitle",{defaultMessage:"Trial"}),s=g.i18n.translate("xpack.grokDebugger.basicLicenseTitle",{defaultMessage:"Basic"}),r=g.i18n.translate("xpack.grokDebugger.goldLicenseTitle",{defaultMessage:"Gold"}),n=g.i18n.translate("xpack.grokDebugger.platinumLicenseTitle",{defaultMessage:"Platinum"});return(0,m.jsx)(c.EuiPage,null,(0,m.jsx)(c.EuiPageBody,{component:"div"},(0,m.jsx)(c.EuiPageSection,{alignment:"center",grow:!0,color:"plain"},(0,m.jsx)(c.EuiCallOut,{title:g.i18n.translate("xpack.grokDebugger.licenseErrorMessageTitle",{defaultMessage:"License error"}),color:"danger",iconType:"warning",style:{padding:"16px"}},(0,m.jsx)(c.EuiText,{size:"s"},(0,m.jsx)("p",null,(0,m.jsx)(d.FormattedMessage,{id:"xpack.grokDebugger.licenseErrorMessageDescription",defaultMessage:"The Grok Debugger requires an active license ({licenseTypeList} or {platinumLicenseType}), but none were found in your cluster.",values:{licenseTypeList:(0,m.jsx)(a().Fragment,null,(0,m.jsx)(c.EuiCode,null,t),", ",(0,m.jsx)(c.EuiCode,null,s),","," ",(0,m.jsx)(c.EuiCode,null,r)),platinumLicenseType:(0,m.jsx)(c.EuiCode,null,n)}})),(0,m.jsx)("p",null,(0,m.jsx)(d.FormattedMessage,{id:"xpack.grokDebugger.registerLicenseDescription",defaultMessage:"Please {registerLicenseLink} to continue using the Grok Debugger",values:{registerLicenseLink:(0,m.jsx)(c.EuiLink,{href:"https://www.elastic.co/subscriptions",rel:"noopener"},e)}})))))))};function C(e,t,s,r){const a=e.isActive?(0,m.jsx)(u.KibanaRenderContextProvider,s,(0,m.jsx)(i.KibanaContextProvider,{services:{...s}},(0,m.jsx)(j,{grokdebuggerService:new GrokdebuggerService(s.http)}))):(0,m.jsx)(u.KibanaRenderContextProvider,{theme$:r},(0,m.jsx)(v,{license:e}));return(0,n.render)(a,t),()=>(0,n.unmountComponentAtNode)(t)}},915:(e,t,s)=>{e.exports=s(497)(67493)}}]);