"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PatternInput = PatternInput;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _codeEditor = require("@kbn/code-editor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function PatternInput({
  value,
  onChange
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.grokDebugger.grokPatternLabel",
      defaultMessage: "Grok Pattern"
    }),
    fullWidth: true,
    "data-test-subj": "patternInput"
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    languageId: _codeEditor.GROK_LANG_ID,
    value: value,
    height: 200,
    options: {
      tabSize: 2,
      automaticLayout: true
    },
    "aria-label": _i18n.i18n.translate('xpack.grokDebugger.grokPatternAriaLabel', {
      defaultMessage: 'Code editor for inputting the grok pattern'
    }),
    onChange: onChange
  }));
}