"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoticeModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../../../hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoticeModal = ({
  noticePath,
  onClose
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const [notice, setNotice] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    async function fetchData() {
      try {
        const {
          data
        } = await (0, _hooks.sendGetFileByPath)(noticePath);
        setNotice(data || '');
      } catch (err) {
        notifications.toasts.addError(err, {
          title: _i18n.i18n.translate('xpack.fleet.epm.errorLoadingNotice', {
            defaultMessage: 'Error loading NOTICE.txt'
          })
        });
      }
    }
    fetchData();
  }, [noticePath, notifications]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    maxWidth: true,
    onClose: onClose,
    "aria-labelledby": modalTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId
  }, "NOTICE.txt")), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    overflowHeight: 360
  }, notice ? notice :
  /*#__PURE__*/
  // Simulate a long notice while loading
  _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 5
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 6
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    onClick: onClose
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.noticeModalCloseBtn",
    defaultMessage: "Close"
  }))));
};
exports.NoticeModal = NoticeModal;