"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentMigrateFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../../hooks");
var _headers_input = require("./headers_input");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AgentMigrateFlyout = ({
  agents,
  onClose,
  onSave,
  protectedAndFleetAgents
}) => {
  var _formContent$settings, _formContent$settings2, _formContent$settings3, _formContent$settings4, _formContent$settings5, _formContent$settings6, _formContent$settings7, _formContent$settings8, _replace_token, _formContent$settings9;
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const migrateAgent = _hooks.useMigrateSingleAgent;
  const migrateAgents = _hooks.useBulkMigrateAgents;
  const [formValid, setFormValid] = _react.default.useState(false);
  const [validClusterURL, setValidClusterURL] = _react.default.useState(false);
  const [formContent, setFormContent] = _react.default.useState({
    id: '',
    agents: [],
    uri: '',
    enrollment_token: '',
    settings: {}
  });
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  (0, _react.useEffect)(() => {
    const validateForm = () => {
      if (formContent.uri && formContent.enrollment_token && validClusterURL) {
        setFormValid(true);
      } else {
        setFormValid(false);
      }
    };
    const validateClusterURL = () => {
      if (formContent.uri) {
        // check that the uri matches a valid URI schema using URL constructor
        try {
          new URL(formContent.uri);
          setValidClusterURL(true);
        } catch (e) {
          setValidClusterURL(false);
        }
      } else {
        setValidClusterURL(false);
      }
    };
    validateClusterURL();
    validateForm();
  }, [formContent, validClusterURL]);
  const submitForm = () => {
    try {
      if (agents.length === 1) {
        migrateAgent({
          ...formContent,
          id: agents[0].id
        });
      } else {
        migrateAgents({
          ...formContent,
          agents: agents.map(agent => agent.id)
        });
      }
      notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('xpack.fleet.agentList.migrateAgentFlyout.successNotificationTitle', {
          defaultMessage: 'Agent migration initiated'
        }),
        text: _i18n.i18n.translate('xpack.fleet.agentList.migrateAgentFlyout.successNotificationDescription', {
          defaultMessage: 'The agent migration process has been successfully initiated.'
        })
      });
      onSave();
    } catch (e) {
      notifications.toasts.addError(e, {
        title: _i18n.i18n.translate('xpack.fleet.agentList.migrateAgentFlyout.errorNotificationTitle', {
          defaultMessage: 'Failed to migrate agent'
        }),
        toastMessage: _i18n.i18n.translate('xpack.fleet.agentList.migrateAgentFlyout.errorNotificationDescription', {
          defaultMessage: 'The agent migration process has failed.'
        })
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    "data-test-subj": "migrateAgentFlyout",
    onClose: onClose,
    "aria-labelledby": flyoutTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h1", {
    id: flyoutTitleId
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.migrateAgentFlyout.title",
    defaultMessage: "Migrate {agentCount, plural, one {agent} other {agents}}",
    values: {
      agentCount: agents.length
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.migrateAgentFlyout.title",
    defaultMessage: "Move {agentCount, plural, one {this agent} other {these agents}} to a different Fleet Server by specifying a new cluster URL and enrollment token.",
    values: {
      agentCount: agents.length
    }
  })), protectedAndFleetAgents.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "warning",
    "data-test-subj": "migrateAgentFlyoutAlertPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "warning",
    className: "eui-alignMiddle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.migrateAgentFlyout.warning",
    defaultMessage: "{icon} {x} of {y} selected agents cannot be migrated as they are tamper protected or Fleet Server agents.",
    values: {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "warning"
      }),
      x: protectedAndFleetAgents.length,
      y: agents.length + protectedAndFleetAgents.length
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "migrateAgentFlyoutWarningAccordion",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => {}
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.warningAccordion",
      defaultMessage: "View Hosts"
    })),
    initialIsOpen: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("ul", null, protectedAndFleetAgents.map(agent => {
    var _agent$local_metadata, _agent$local_metadata2;
    return /*#__PURE__*/_react.default.createElement("li", {
      key: agent.id
    }, (_agent$local_metadata = agent.local_metadata) === null || _agent$local_metadata === void 0 ? void 0 : (_agent$local_metadata2 = _agent$local_metadata.host) === null || _agent$local_metadata2 === void 0 ? void 0 : _agent$local_metadata2.hostname);
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.clusterUrlLabel",
      defaultMessage: "Remote Cluster URL"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.clusterUrlHelpText",
      defaultMessage: "Enter the URL of the Fleet server in the target cluster you want the agent to migrate to"
    }),
    isInvalid: !validClusterURL && formContent.uri !== '',
    error: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.clusterUrlError",
      defaultMessage: "Invalid cluster URL"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: !validClusterURL && formContent.uri !== '',
    placeholder: _i18n.i18n.translate('xpack.fleet.agentList.migrateAgentFlyout.clusterUrlPlaceholder', {
      defaultMessage: 'Enter a valid cluster URL'
    }),
    fullWidth: true,
    onChange: e => setFormContent({
      ...formContent,
      uri: e.target.value
    }),
    "data-test-subj": "migrateAgentFlyoutClusterUrlInput"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.enrollmentTokenLabel",
      defaultMessage: "Enrollment Token"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.enrollmentTokenHelpText",
      defaultMessage: "Enter a valid enrollment token generated in the target cluster"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
    "data-test-subj": "migrateAgentFlyoutEnrollmentTokenInput",
    onChange: e => setFormContent({
      ...formContent,
      enrollment_token: e.target.value
    }),
    placeholder: _i18n.i18n.translate('xpack.fleet.agentList.migrateAgentFlyout.enrollmentTokenPlaceholder', {
      defaultMessage: 'Enter a valid enrollment token'
    }),
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    arrowDisplay: "right",
    id: "migrateAgentFlyoutAdditionalOptions",
    initialIsOpen: false,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.additionalOptionsLabel",
      defaultMessage: "Advanced options"
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "tlsCertsSection",
    initialIsOpen: true,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "primary"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.tlsCertsLabel",
      defaultMessage: "TLS & Certs"
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.migrateAgentFlyout.tlsCertsDescriptionLabel",
    defaultMessage: "Provide optional TLS settings if your target Fleet server uses custom certificates."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "ca_sha256",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    onChange: e => setFormContent({
      ...formContent,
      settings: {
        ...formContent.settings,
        ca_sha256: e.target.value
      }
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.certAuthLabel",
      defaultMessage: "Certificate Authorities"
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    onChange: e => setFormContent({
      ...formContent,
      settings: {
        ...formContent.settings,
        certificate_authorities: e.target.value
      }
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.elasticAgentCertLabel",
      defaultMessage: "Elastic Agent Certificate"
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    onChange: e => setFormContent({
      ...formContent,
      settings: {
        ...formContent.settings,
        elastic_agent_cert: e.target.value
      }
    }),
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.elasticAgentCertKeyLabel",
      defaultMessage: "Elastic Agent Certificate Key"
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    onChange: e => setFormContent({
      ...formContent,
      settings: {
        ...formContent.settings,
        elastic_agent_cert_key: e.target.value
      }
    }),
    fullWidth: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "headersSection",
    initialIsOpen: true,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "primary"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.headersMainLabel",
      defaultMessage: "Headers"
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.migrateAgentFlyout.headersDescriptionLabel",
    defaultMessage: "Custom HTTP headers sent during agent enrollment."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.headersLabel",
      defaultMessage: "Headers"
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_headers_input.HeadersInput, {
    headers: ((_formContent$settings = formContent.settings) === null || _formContent$settings === void 0 ? void 0 : _formContent$settings.headers) || {},
    onUpdate: headers => setFormContent({
      ...formContent,
      settings: {
        ...formContent.settings,
        headers
      }
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.proxyHeadersLabel",
      defaultMessage: "Proxy Headers"
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_headers_input.HeadersInput, {
    headers: ((_formContent$settings2 = formContent.settings) === null || _formContent$settings2 === void 0 ? void 0 : _formContent$settings2.proxy_headers) || {},
    onUpdate: headers => setFormContent({
      ...formContent,
      settings: {
        ...formContent.settings,
        proxy_headers: headers
      }
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "networkingSection",
    initialIsOpen: true,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "primary"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.networkingLabel",
      defaultMessage: "Networking"
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.migrateAgentFlyout.networkingDescriptionLabel",
    defaultMessage: "Configure proxy settings if your network requires routing traffic through a proxy server."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.proxyUrlLabel",
      defaultMessage: "Proxy URL"
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    onChange: e => setFormContent({
      ...formContent,
      settings: {
        ...formContent.settings,
        proxy_url: e.target.value
      }
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "headersSection",
    initialIsOpen: true,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "primary"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.agentOptionsLabel",
      defaultMessage: "Agent Options"
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.migrateAgentFlyout.agentOptionsDescriptionLabel",
    defaultMessage: "Customize behavior during migration. Control connection handling, staging environments, and token replacement logic."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.insecurelabel",
      defaultMessage: "Insecure"
    }),
    checked: (_formContent$settings3 = (_formContent$settings4 = formContent.settings) === null || _formContent$settings4 === void 0 ? void 0 : _formContent$settings4.insecure) !== null && _formContent$settings3 !== void 0 ? _formContent$settings3 : false,
    onChange: e => setFormContent({
      ...formContent,
      settings: {
        ...formContent.settings,
        insecure: e.target.checked
      }
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.stagingLabel",
      defaultMessage: "Staging"
    }),
    checked: (_formContent$settings5 = (_formContent$settings6 = formContent.settings) === null || _formContent$settings6 === void 0 ? void 0 : _formContent$settings6.staging) !== null && _formContent$settings5 !== void 0 ? _formContent$settings5 : false,
    onChange: e => setFormContent({
      ...formContent,
      settings: {
        ...formContent.settings,
        staging: e.target.checked
      }
    })
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.proxyLabel",
      defaultMessage: "Proxy Disabled"
    }),
    checked: (_formContent$settings7 = (_formContent$settings8 = formContent.settings) === null || _formContent$settings8 === void 0 ? void 0 : _formContent$settings8.proxy_disabled) !== null && _formContent$settings7 !== void 0 ? _formContent$settings7 : false,
    onChange: e => setFormContent({
      ...formContent,
      settings: {
        ...formContent.settings,
        proxy_disabled: e.target.checked
      }
    })
  })), agents.length === 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "migrateAgentFlyoutReplaceTokenButton",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentFlyout.replaceTokenLabel",
      defaultMessage: "Replace Token"
    }),
    checked: (_replace_token = (_formContent$settings9 = formContent.settings) === null || _formContent$settings9 === void 0 ? void 0 : _formContent$settings9.replace_token) !== null && _replace_token !== void 0 ? _replace_token : false,
    onChange: e => {
      // Only allow setting replace_token when migrating a single agent
      if ('id' in formContent) {
        setFormContent({
          ...formContent,
          settings: {
            ...formContent.settings,
            replace_token: e.target.checked
          }
        });
      }
    }
  })))))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    "data-test-subj": "migrateAgentFlyoutCancelButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.migrateAgentFlyout.cancelButtonLabel",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: !formValid,
    onClick: submitForm,
    fill: true,
    "data-test-subj": "migrateAgentFlyoutSubmitButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.migrateAgentFlyout.submitButtonLabel",
    defaultMessage: "Migrate {agentCount, plural, one {# agent} other {# agents}}",
    values: {
      agentCount: agents.length
    }
  }))))));
};
exports.AgentMigrateFlyout = AgentMigrateFlyout;