"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StandaloneModeWarningCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StandaloneModeWarningCallout = ({
  setIsManaged
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: "Setting up to run Elastic Agent in standalone mode",
    color: "primary",
    iconType: "info"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addIntegration.standaloneWarning",
    defaultMessage: "Setting up integrations by running Elastic Agent in standalone mode is advanced. When possible, we recommend using {link} instead. ",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "#"
      }, "Fleet-managed agents")
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => setIsManaged(true),
    color: "primary"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.addIntegration.switchToManagedButton",
    defaultMessage: "Enroll in Fleet instead (recommended)"
  })));
};
exports.StandaloneModeWarningCallout = StandaloneModeWarningCallout;