"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isWhereExpression = exports.isStringLiteral = exports.isSource = exports.isProperNode = exports.isParamLiteral = exports.isOptionNode = exports.isLiteral = exports.isList = exports.isIntegerLiteral = exports.isIdentifier = exports.isFunctionExpression = exports.isFieldExpression = exports.isDoubleLiteral = exports.isColumn = exports.isBooleanLiteral = exports.isBinaryExpression = exports.isAsExpression = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isProperNode = node => !!node && typeof node === 'object' && !Array.isArray(node) && typeof node.type === 'string' && !!node.type;
exports.isProperNode = isProperNode;
const isFunctionExpression = node => isProperNode(node) && node.type === 'function';

/**
 * Returns true if the given node is a binary expression, i.e. an operator
 * surrounded by two operands:
 *
 * ```
 * 1 + 1
 * column LIKE "foo"
 * foo = "bar"
 * ```
 *
 * @param node Any ES|QL AST node.
 */
exports.isFunctionExpression = isFunctionExpression;
const isBinaryExpression = node => isFunctionExpression(node) && node.subtype === 'binary-expression';
exports.isBinaryExpression = isBinaryExpression;
const isWhereExpression = node => isBinaryExpression(node) && node.name === 'where';
exports.isWhereExpression = isWhereExpression;
const isAsExpression = node => isBinaryExpression(node) && node.name === 'as';
exports.isAsExpression = isAsExpression;
const isFieldExpression = node => isBinaryExpression(node) && node.name === '=';
exports.isFieldExpression = isFieldExpression;
const isLiteral = node => isProperNode(node) && node.type === 'literal';
exports.isLiteral = isLiteral;
const isStringLiteral = node => isLiteral(node) && node.literalType === 'keyword';
exports.isStringLiteral = isStringLiteral;
const isIntegerLiteral = node => isLiteral(node) && node.literalType === 'integer';
exports.isIntegerLiteral = isIntegerLiteral;
const isDoubleLiteral = node => isLiteral(node) && node.literalType === 'double';
exports.isDoubleLiteral = isDoubleLiteral;
const isBooleanLiteral = node => isLiteral(node) && node.literalType === 'boolean';
exports.isBooleanLiteral = isBooleanLiteral;
const isParamLiteral = node => isLiteral(node) && node.literalType === 'param';
exports.isParamLiteral = isParamLiteral;
const isColumn = node => isProperNode(node) && node.type === 'column';
exports.isColumn = isColumn;
const isSource = node => isProperNode(node) && node.type === 'source';
exports.isSource = isSource;
const isIdentifier = node => isProperNode(node) && node.type === 'identifier';
exports.isIdentifier = isIdentifier;
const isList = node => isProperNode(node) && node.type === 'list';
exports.isList = isList;
const isOptionNode = node => {
  return !!node && typeof node === 'object' && !Array.isArray(node) && node.type === 'option';
};
exports.isOptionNode = isOptionNode;