"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHeaderActions = void 0;
var _react = _interopRequireDefault(require("react"));
var _indices = require("../../../utils/indices");
var _search_playground_popover = require("../../search_index/components/header_actions/search_playground_popover");
var _syncs_context_menu = require("./syncs_context_menu");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Used to populate rightSideItems of an EuiPageTemplate, which is rendered right-to-left
const getHeaderActions = (indexData, connector) => {
  const ingestionMethod = (0, _indices.getIngestionMethod)(indexData);
  return [...((0, _indices.isConnectorIndex)(indexData) || connector ? [/*#__PURE__*/_react.default.createElement(_syncs_context_menu.SyncsContextMenu, null)] : []), ...(indexData ? [/*#__PURE__*/_react.default.createElement(_search_playground_popover.SearchPlaygroundPopover, {
    indexName: indexData === null || indexData === void 0 ? void 0 : indexData.name,
    ingestionMethod: ingestionMethod
  })] : [])];
};
exports.getHeaderActions = getHeaderActions;