"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchPipeline = exports.FetchPipelineApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchPipeline = async ({
  pipelineName
}) => {
  const route = `/internal/enterprise_search/pipelines/${pipelineName}`;
  return await _http.HttpLogic.values.http.get(route);
};
exports.fetchPipeline = fetchPipeline;
const FetchPipelineApiLogic = exports.FetchPipelineApiLogic = (0, _create_api_logic.createApiLogic)(['fetch_pipeline_api_logic'], fetchPipeline, {
  showErrorFlash: false
});