"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getQualityIssuesColumns = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = _interopRequireDefault(require("react"));
var _constants = require("../../../../../common/constants");
var _translations = require("../../../../../common/translations");
var _spark_plot = require("../../../common/spark_plot");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const expandDatasetAriaLabel = _i18n.i18n.translate('xpack.datasetQuality.details.qualityIssuesTable.expandLabel', {
  defaultMessage: 'Expand'
});
const collapseDatasetAriaLabel = _i18n.i18n.translate('xpack.datasetQuality.details.qualityIssuesTable.collapseLabel', {
  defaultMessage: 'Collapse'
});
const getQualityIssuesColumns = ({
  dateFormatter,
  isLoading,
  expandedQualityIssue,
  openQualityIssueFlyout
}) => [{
  name: '',
  field: 'name',
  render: (_, {
    name,
    type
  }) => {
    const isExpanded = name === (expandedQualityIssue === null || expandedQualityIssue === void 0 ? void 0 : expandedQualityIssue.name) && type === (expandedQualityIssue === null || expandedQualityIssue === void 0 ? void 0 : expandedQualityIssue.type);
    const onExpandClick = () => {
      openQualityIssueFlyout(name, type);
    };
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "datasetQualityDetailsQualityIssuesExpandButton",
      size: "xs",
      color: "text",
      onClick: onExpandClick,
      iconType: isExpanded ? 'minimize' : 'expand',
      title: !isExpanded ? expandDatasetAriaLabel : collapseDatasetAriaLabel,
      "aria-label": !isExpanded ? expandDatasetAriaLabel : collapseDatasetAriaLabel
    });
  },
  width: '40px',
  css: (0, _react.css)`
      &.euiTableCellContent {
        padding: 0;
      }
    `
}, {
  name: _translations.issueColumnName,
  field: 'name',
  render: (_, {
    name,
    type
  }) => {
    return type === 'degraded' ? /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.datasetQuality.details.qualityIssues.degradedField",
      defaultMessage: "{name} field ignored",
      values: {
        name: /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement("strong", null, name), ' ')
      }
    })) : /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, _translations.documentIndexFailed);
  }
}, {
  name: _translations.countColumnName,
  sortable: true,
  field: 'count',
  render: (_, {
    count,
    timeSeries
  }) => {
    const countValue = (0, _eui.formatNumber)(count, _constants.NUMBER_FORMAT);
    return /*#__PURE__*/_react2.default.createElement(_spark_plot.SparkPlot, {
      series: timeSeries,
      valueLabel: countValue,
      isLoading: isLoading
    });
  }
}, {
  name: _translations.lastOccurrenceColumnName,
  sortable: true,
  field: 'lastOccurrence',
  render: lastOccurrence => {
    return dateFormatter.convert(lastOccurrence);
  }
}];
exports.getQualityIssuesColumns = getQualityIssuesColumns;