"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateFormErrors = exports.AutoFollowPatternForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _shared_imports = require("../../shared_imports");
var _routing = require("../services/routing");
var _get_remote_cluster_name = require("../services/get_remote_cluster_name");
var _constants = require("../constants");
var _section_error = require("./section_error");
var _auto_follow_pattern_indices_preview = require("./auto_follow_pattern_indices_preview");
var _remote_clusters_form_field = require("./remote_clusters_form_field");
var _auto_follow_pattern_validators = require("../services/auto_follow_pattern_validators");
var _auto_follow_pattern_request_flyout = require("./auto_follow_pattern_request_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const indexPatternIllegalCharacters = _public.indexPatterns.ILLEGAL_CHARACTERS_VISIBLE.join(' ');
const indexNameIllegalCharacters = _shared_imports.indices.INDEX_ILLEGAL_CHARACTERS_VISIBLE.join(' ');
const getEmptyAutoFollowPattern = (remoteClusterName = '') => ({
  name: '',
  remoteCluster: remoteClusterName,
  leaderIndexPatterns: [],
  followIndexPatternPrefix: '',
  followIndexPatternSuffix: ''
});
const updateFormErrors = (errors, existingErrors) => ({
  fieldsErrors: {
    ...existingErrors,
    ...errors
  }
});
exports.updateFormErrors = updateFormErrors;
class AutoFollowPatternForm extends _react.PureComponent {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "toggleRequest", () => {
      this.setState(({
        isRequestVisible
      }) => ({
        isRequestVisible: !isRequestVisible
      }));
    });
    (0, _defineProperty2.default)(this, "onFieldsChange", fields => {
      this.setState(({
        autoFollowPattern
      }) => ({
        autoFollowPattern: {
          ...autoFollowPattern,
          ...fields
        }
      }));
      const errors = (0, _auto_follow_pattern_validators.validateAutoFollowPattern)(fields);
      this.onFieldsErrorChange(errors);
    });
    (0, _defineProperty2.default)(this, "onFieldsErrorChange", errors => this.setState(({
      fieldsErrors
    }) => updateFormErrors(errors, fieldsErrors)));
    (0, _defineProperty2.default)(this, "onClusterChange", remoteCluster => {
      this.onFieldsChange({
        remoteCluster
      });
    });
    (0, _defineProperty2.default)(this, "onCreateLeaderIndexPattern", indexPattern => {
      const error = (0, _auto_follow_pattern_validators.validateLeaderIndexPattern)(indexPattern);
      if (error) {
        const errors = {
          leaderIndexPatterns: {
            ...error,
            alwaysVisible: true
          }
        };
        this.setState(({
          fieldsErrors
        }) => updateFormErrors(errors, fieldsErrors));

        // Return false to explicitly reject the user's input.
        return false;
      }
      const {
        autoFollowPattern: {
          leaderIndexPatterns
        }
      } = this.state;
      const newLeaderIndexPatterns = [...leaderIndexPatterns, indexPattern];
      this.onFieldsChange({
        leaderIndexPatterns: newLeaderIndexPatterns
      });
    });
    (0, _defineProperty2.default)(this, "onLeaderIndexPatternChange", indexPatterns => {
      this.onFieldsChange({
        leaderIndexPatterns: indexPatterns.map(({
          label
        }) => label)
      });
    });
    (0, _defineProperty2.default)(this, "onLeaderIndexPatternInputChange", leaderIndexPattern => {
      const isEmpty = !leaderIndexPattern || !leaderIndexPattern.trim();
      const {
        autoFollowPattern: {
          leaderIndexPatterns
        }
      } = this.state;
      if (!isEmpty && leaderIndexPatterns.includes(leaderIndexPattern)) {
        const errorMsg = _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPatternForm.leaderIndexPatternError.duplicateMessage', {
          defaultMessage: `Duplicate leader index pattern aren't allowed.`
        });
        const errors = {
          leaderIndexPatterns: {
            message: errorMsg,
            alwaysVisible: true
          }
        };
        this.setState(({
          fieldsErrors
        }) => updateFormErrors(errors, fieldsErrors));
      } else {
        this.setState(({
          fieldsErrors,
          autoFollowPattern: {
            leaderIndexPatterns
          }
        }) => {
          const errors = Boolean(leaderIndexPatterns.length) ?
          // Validate existing patterns, so we can surface an error if this required input is missing.
          (0, _auto_follow_pattern_validators.validateAutoFollowPattern)({
            leaderIndexPatterns
          }) :
          // Validate the input as the user types so they have immediate feedback about errors.
          (0, _auto_follow_pattern_validators.validateAutoFollowPattern)({
            leaderIndexPatterns: [leaderIndexPattern]
          });
          return updateFormErrors(errors, fieldsErrors);
        });
      }
    });
    (0, _defineProperty2.default)(this, "getFields", () => {
      const {
        autoFollowPattern: stateFields
      } = this.state;
      const {
        followIndexPatternPrefix,
        followIndexPatternSuffix,
        ...rest
      } = stateFields;
      return {
        ...rest,
        followIndexPattern: `${followIndexPatternPrefix}{{leader_index}}${followIndexPatternSuffix}`
      };
    });
    (0, _defineProperty2.default)(this, "sendForm", () => {
      const isFormValid = this.isFormValid();
      if (!isFormValid) {
        this.setState({
          areErrorsVisible: true
        });
        return;
      }
      this.setState({
        areErrorsVisible: false
      });
      const {
        name,
        ...autoFollowPattern
      } = this.getFields();
      this.props.saveAutoFollowPattern(name, autoFollowPattern);
    });
    (0, _defineProperty2.default)(this, "cancelForm", () => {
      _routing.routing.navigate('/auto_follow_patterns');
    });
    (0, _defineProperty2.default)(this, "renderForm", () => {
      const {
        autoFollowPattern: {
          name,
          remoteCluster,
          leaderIndexPatterns,
          followIndexPatternPrefix,
          followIndexPatternSuffix
        },
        isNew,
        areErrorsVisible,
        fieldsErrors
      } = this.state;

      /**
       * Auto-follow pattern Name
       */
      const renderAutoFollowPatternName = () => {
        const isInvalid = areErrorsVisible && !!fieldsErrors.name;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
          title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
            size: "s"
          }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.sectionAutoFollowPatternNameTitle",
            defaultMessage: "Name"
          }))),
          description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.sectionAutoFollowPatternNameDescription",
            defaultMessage: "A unique name for the auto-follow pattern."
          }),
          fullWidth: true
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
          label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.autoFollowPatternName.fieldNameLabel",
            defaultMessage: "Name"
          }),
          error: fieldsErrors.name,
          isInvalid: isInvalid,
          fullWidth: true
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
          isInvalid: isInvalid,
          value: name,
          onChange: e => this.onFieldsChange({
            name: e.target.value
          }),
          fullWidth: true,
          disabled: !isNew,
          "data-test-subj": "nameInput"
        })));
      };

      /**
       * Remote Cluster
       */
      const renderRemoteClusterField = () => {
        const {
          remoteClusters,
          currentUrl
        } = this.props;
        const errorMessages = {
          noClusterFound: () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.emptyRemoteClustersCallOutDescription",
            defaultMessage: "Auto-follow patterns capture indices on remote clusters."
          }),
          remoteClusterNotConnectedNotEditable: name => ({
            title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.crossClusterReplication.autoFollowPatternForm.currentRemoteClusterNotConnectedCallOutTitle",
              defaultMessage: "Can't edit auto-follow pattern because remote cluster ''{name}'' is not connected",
              values: {
                name
              }
            }),
            description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.crossClusterReplication.autoFollowPatternForm.currentRemoteClusterNotConnectedCallOutDescription",
              defaultMessage: "You can address this by editing the remote cluster."
            })
          }),
          remoteClusterDoesNotExist: name => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.currentRemoteClusterNotFoundCallOutDescription",
            defaultMessage: "To edit this auto-follow pattern, you must add a remote cluster named ''{name}''.",
            values: {
              name
            }
          })
        };
        return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
          title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
            size: "s"
          }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.sectionRemoteClusterTitle",
            defaultMessage: "Remote cluster"
          }))),
          description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.sectionRemoteClusterDescription",
            defaultMessage: "The remote cluster to replicate leader indices from."
          }),
          fullWidth: true
        }, /*#__PURE__*/_react.default.createElement(_remote_clusters_form_field.RemoteClustersFormField, {
          selected: remoteCluster ? remoteCluster : null,
          remoteClusters: remoteClusters,
          currentUrl: currentUrl,
          isEditable: isNew,
          areErrorsVisible: areErrorsVisible,
          onChange: this.onClusterChange,
          onError: error => this.onFieldsErrorChange({
            remoteCluster: error
          }),
          errorMessages: errorMessages
        }));
      };

      /**
       * Leader index pattern(s)
       */
      const renderLeaderIndexPatterns = () => {
        const hasError = !!(fieldsErrors.leaderIndexPatterns && fieldsErrors.leaderIndexPatterns.message);
        const isInvalid = hasError && (fieldsErrors.leaderIndexPatterns.alwaysVisible || areErrorsVisible);
        const formattedLeaderIndexPatterns = leaderIndexPatterns.map(pattern => ({
          label: pattern
        }));
        return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
          title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
            size: "s"
          }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.sectionLeaderIndexPatternsTitle",
            defaultMessage: "Leader indices"
          }))),
          description: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.sectionLeaderIndexPatternsDescription1",
            defaultMessage: "One or more index patterns that identify the indices you want to replicate from the remote cluster. As new indices matching these patterns are created, they are replicated to follower indices on the local cluster."
          })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.sectionLeaderIndexPatternsDescription2",
            defaultMessage: "{note} Indices that already exist are not replicated.",
            values: {
              note: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
                id: "xpack.crossClusterReplication.autoFollowPatternForm.sectionLeaderIndexPatternsDescription2.noteLabel",
                defaultMessage: "Note:"
              }))
            }
          }))),
          fullWidth: true
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
          label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.fieldLeaderIndexPatternsLabel",
            defaultMessage: "Index patterns"
          }),
          helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.fieldLeaderIndexPatternsHelpLabel",
            defaultMessage: "Spaces and the characters {characterList} are not allowed.",
            values: {
              characterList: /*#__PURE__*/_react.default.createElement("strong", null, indexPatternIllegalCharacters)
            }
          }),
          isInvalid: isInvalid,
          error: fieldsErrors.leaderIndexPatterns && fieldsErrors.leaderIndexPatterns.message,
          fullWidth: true
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
          isInvalid: isInvalid,
          noSuggestions: true,
          placeholder: _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPatternForm.fieldLeaderIndexPatternsPlaceholder', {
            defaultMessage: 'Type and then hit ENTER'
          }),
          selectedOptions: formattedLeaderIndexPatterns,
          onCreateOption: this.onCreateLeaderIndexPattern,
          onChange: this.onLeaderIndexPatternChange,
          onSearchChange: this.onLeaderIndexPatternInputChange,
          fullWidth: true,
          "data-test-subj": "indexPatternInput"
        })));
      };

      /**
       * Auto-follow pattern prefix/suffix
       */
      const renderAutoFollowPatternPrefixSuffix = () => {
        const isPrefixInvalid = areErrorsVisible && !!fieldsErrors.followIndexPatternPrefix;
        const isSuffixInvalid = areErrorsVisible && !!fieldsErrors.followIndexPatternSuffix;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
          title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
            size: "s"
          }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.sectionAutoFollowPatternTitle",
            defaultMessage: "Follower indices (optional)"
          }))),
          description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.sectionAutoFollowPatternDescription",
            defaultMessage: "A custom prefix or suffix to apply to the names of the follower indices so you can more easily identify replicated indices. By default, a follower index has the same name as the leader index."
          }),
          fullWidth: true
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
          label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.autoFollowPattern.fieldPrefixLabel",
            defaultMessage: "Prefix"
          }),
          error: fieldsErrors.followIndexPatternPrefix,
          isInvalid: isPrefixInvalid,
          fullWidth: true
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
          isInvalid: isPrefixInvalid,
          value: followIndexPatternPrefix,
          onChange: e => this.onFieldsChange({
            followIndexPatternPrefix: e.target.value
          }),
          fullWidth: true,
          "data-test-subj": "prefixInput"
        }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
          label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.autoFollowPattern.fieldSuffixLabel",
            defaultMessage: "Suffix"
          }),
          error: fieldsErrors.followIndexPatternSuffix,
          isInvalid: isSuffixInvalid,
          fullWidth: true
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
          isInvalid: isSuffixInvalid,
          value: followIndexPatternSuffix,
          onChange: e => this.onFieldsChange({
            followIndexPatternSuffix: e.target.value
          }),
          fullWidth: true,
          "data-test-subj": "suffixInput"
        })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormHelpText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.autoFollowPatternForm.fieldFollowerIndicesHelpLabel",
          defaultMessage: "Spaces and the characters {characterList} are not allowed.",
          values: {
            characterList: /*#__PURE__*/_react.default.createElement("strong", null, indexNameIllegalCharacters)
          }
        })), !!leaderIndexPatterns.length && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m"
        }), /*#__PURE__*/_react.default.createElement(_auto_follow_pattern_indices_preview.AutoFollowPatternIndicesPreview, {
          prefix: followIndexPatternPrefix,
          suffix: followIndexPatternSuffix,
          leaderIndexPatterns: leaderIndexPatterns
        })));
      };

      /**
       * Form Error warning message
       */
      const renderFormErrorWarning = () => {
        const {
          areErrorsVisible
        } = this.state;
        const isFormValid = this.isFormValid();
        if (!areErrorsVisible || isFormValid) {
          return null;
        }
        return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
          role: "alert",
          title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.validationErrorTitle",
            defaultMessage: "Fix errors before continuing."
          }),
          color: "danger",
          iconType: "cross",
          "data-test-subj": "formError"
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "l"
        }));
      };

      /**
       * Form Actions
       */
      const renderActions = () => {
        const {
          apiStatus,
          saveButtonLabel
        } = this.props;
        const {
          areErrorsVisible,
          isRequestVisible
        } = this.state;
        if (apiStatus === _constants.API_STATUS.SAVING) {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            justifyContent: "flexStart",
            gutterSize: "m"
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
            size: "l"
          })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.crossClusterReplication.autoFollowPatternForm.actions.savingText",
            defaultMessage: "Saving"
          }))));
        }
        const isSaveDisabled = areErrorsVisible && !this.isFormValid();
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          justifyContent: "spaceBetween",
          alignItems: "center"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "m",
          alignItems: "center"
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
          color: "success",
          iconType: "check",
          onClick: this.sendForm,
          fill: true,
          disabled: isSaveDisabled,
          "data-test-subj": "submitButton"
        }, saveButtonLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
          color: "primary",
          onClick: this.cancelForm
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.autoFollowPatternForm.cancelButtonLabel",
          defaultMessage: "Cancel",
          "data-test-subj": "cancelButton"
        })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
          onClick: this.toggleRequest
        }, isRequestVisible ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.autoFollowPatternForm.hideRequestButtonLabel",
          defaultMessage: "Hide request"
        }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.autoFollowPatternFormm.showRequestButtonLabel",
          defaultMessage: "Show request"
        }))));
      };
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
        "data-test-subj": "autoFollowPatternForm"
      }, renderAutoFollowPatternName(), renderRemoteClusterField(), renderLeaderIndexPatterns(), renderAutoFollowPatternPrefixSuffix()), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), renderFormErrorWarning(), this.renderApiErrors(), renderActions());
    });
    (0, _defineProperty2.default)(this, "renderLoading", () => {
      const {
        apiStatus
      } = this.props;
      if (apiStatus === _constants.API_STATUS.SAVING) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiOverlayMask, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
          logo: "logoKibana",
          size: "xl"
        }));
      }
      return null;
    });
    const _isNew = this.props.autoFollowPattern === undefined;
    const {
      route: {
        location: {
          search
        }
      }
    } = _routing.routing.reactRouter;
    const queryParams = (0, _shared_imports.extractQueryParams)(search);
    const remoteClusterName = (0, _get_remote_cluster_name.getRemoteClusterName)(this.props.remoteClusters, queryParams.cluster);
    const _autoFollowPattern = _isNew ? getEmptyAutoFollowPattern(remoteClusterName) : {
      ...this.props.autoFollowPattern
    };
    this.state = {
      autoFollowPattern: _autoFollowPattern,
      fieldsErrors: (0, _auto_follow_pattern_validators.validateAutoFollowPattern)(_autoFollowPattern),
      areErrorsVisible: false,
      isNew: _isNew,
      isRequestVisible: false
    };
  }
  isFormValid() {
    return Object.values(this.state.fieldsErrors).every(error => error === undefined || error === null);
  }
  /**
   * Secctions Renders
   */
  renderApiErrors() {
    const {
      apiError
    } = this.props;
    if (apiError) {
      const title = _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPatternForm.savingErrorTitle', {
        defaultMessage: `Can't create auto-follow pattern`
      });
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_section_error.SectionError, {
        title: title,
        error: apiError,
        "data-test-subj": "apiError"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l"
      }));
    }
    return null;
  }
  render() {
    const {
      autoFollowPattern,
      isRequestVisible,
      isNew
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, this.renderForm(), this.renderLoading(), isRequestVisible ? /*#__PURE__*/_react.default.createElement(_auto_follow_pattern_request_flyout.AutoFollowPatternRequestFlyout, {
      name: autoFollowPattern.name,
      autoFollowPattern: this.getFields(),
      isNew: isNew,
      close: () => this.setState({
        isRequestVisible: false
      })
    }) : null);
  }
}
exports.AutoFollowPatternForm = AutoFollowPatternForm;
(0, _defineProperty2.default)(AutoFollowPatternForm, "propTypes", {
  saveAutoFollowPattern: _propTypes.default.func.isRequired,
  autoFollowPattern: _propTypes.default.object,
  apiError: _propTypes.default.object,
  apiStatus: _propTypes.default.string.isRequired,
  currentUrl: _propTypes.default.string.isRequired,
  remoteClusters: _propTypes.default.array,
  saveButtonLabel: _propTypes.default.node
});