"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isSupportedSavedObjectType = exports.isSupportedReferenceType = exports.isDashboardFile = exports.SUPPORTED_SAVED_OBJECT_TYPE = void 0;
var _path = _interopRequireDefault(require("path"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SUPPORTED_SAVED_OBJECT_TYPE = exports.SUPPORTED_SAVED_OBJECT_TYPE = {
  dashboard: 'dashboard',
  'index-pattern': 'index_pattern',
  lens: 'lens'
};
const isSupportedSavedObjectType = entry => {
  return entry.type in SUPPORTED_SAVED_OBJECT_TYPE;
};
exports.isSupportedSavedObjectType = isSupportedSavedObjectType;
const isDashboardFile = (rootDir, filepath) => {
  const subDir = SUPPORTED_SAVED_OBJECT_TYPE.dashboard;
  return _path.default.dirname(filepath) === _path.default.join(rootDir, 'kibana', subDir);
};
exports.isDashboardFile = isDashboardFile;
const isSupportedReferenceType = type => {
  const referenceTypes = ['index-pattern', 'lens'];
  return referenceTypes.some(refType => refType === type);
};
exports.isSupportedReferenceType = isSupportedReferenceType;