"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Rules = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _cloud_posture_page_title = require("../../components/cloud_posture_page_title");
var _rules_container = require("./rules_container");
var _constants = require("../../common/navigation/constants");
var _cloud_posture_page = require("../../components/cloud_posture_page");
var _security_solution_context = require("../../application/security_solution_context");
var _use_csp_benchmark_integrations = require("../benchmarks/use_csp_benchmark_integrations");
var _cis_benchmark_icon = require("../../components/cis_benchmark_icon");
var _helpers = require("../../../common/utils/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Rules = ({
  match: {
    params
  }
}) => {
  var _useSecuritySolutionC;
  const benchmarksInfo = (0, _use_csp_benchmark_integrations.useCspBenchmarkIntegrationsV2)();
  const SpyRoute = (_useSecuritySolutionC = (0, _security_solution_context.useSecuritySolutionContext)()) === null || _useSecuritySolutionC === void 0 ? void 0 : _useSecuritySolutionC.getSpyRouteComponent();
  return /*#__PURE__*/_react.default.createElement(_cloud_posture_page.CloudPosturePage, {
    query: benchmarksInfo
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    alignItems: 'bottom',
    bottomBorder: true,
    pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      style: {
        width: 'fit-content'
      }
    }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Link, {
      to: (0, _reactRouterDom.generatePath)(_constants.cloudPosturePages.benchmarks.path)
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "arrowLeft"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.rules.rulesPageHeader.benchmarkRulesButtonLabel",
      defaultMessage: "Benchmarks"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      style: {
        marginBottom: 6
      }
    }, /*#__PURE__*/_react.default.createElement(_cis_benchmark_icon.CISBenchmarkIcon, {
      type: params.benchmarkId,
      size: 'l'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_cloud_posture_page_title.CloudPosturePageTitle, {
      title: _i18n.i18n.translate('xpack.csp.rules.rulePageHeader.pageHeaderTitle', {
        defaultMessage: '{benchmarkName} {benchmarkVersion} - Rules',
        values: {
          benchmarkName: (0, _helpers.getBenchmarkCisName)(params.benchmarkId),
          benchmarkVersion: params.benchmarkVersion
        }
      })
    })))))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_rules_container.RulesContainer, null), SpyRoute && /*#__PURE__*/_react.default.createElement(SpyRoute, {
    pageName: _constants.cloudPosturePages.benchmarks.id,
    state: {
      ruleName: (0, _helpers.getBenchmarkCisName)(params.benchmarkId)
    }
  }));
};
exports.Rules = Rules;