"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.GCP_SINGLE_ACCOUNT = exports.GCP_ORGANIZATION_ACCOUNT = exports.CspPolicyTemplateForm = exports.AZURE_SINGLE_ACCOUNT = exports.AZURE_ORGANIZATION_ACCOUNT = exports.AWS_SINGLE_ACCOUNT = exports.AWS_ORGANIZATION_ACCOUNT = void 0;
var _react = _interopRequireWildcard(require("react"));
var _compare = _interopRequireDefault(require("semver/functions/compare"));
var _valid = _interopRequireDefault(require("semver/functions/valid"));
var _coerce = _interopRequireDefault(require("semver/functions/coerce"));
var _lt = _interopRequireDefault(require("semver/functions/lt"));
var _gte = _interopRequireDefault(require("semver/functions/gte"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/fleet-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _reactRouterDom = require("react-router-dom");
var _i18n = require("@kbn/i18n");
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _use_is_subscription_status_valid = require("../../common/hooks/use_is_subscription_status_valid");
var _subscription_not_allowed = require("../subscription_not_allowed");
var _csp_boxed_radio_group = require("./csp_boxed_radio_group");
var _helpers = require("../../../common/utils/helpers");
var _constants = require("../../../common/constants");
var _utils = require("./utils");
var _policy_template_selectors = require("./policy_template_selectors");
var _use_package_policy_list = require("../../common/api/use_package_policy_list");
var _gcp_credential_form = require("./gcp_credentials_form/gcp_credential_form");
var _setup_technology_selector = require("./setup_technology_selector/setup_technology_selector");
var _use_setup_technology = require("./setup_technology_selector/use_setup_technology");
var _azure_credentials_form = require("./azure_credentials_form/azure_credentials_form");
var _use_kibana = require("../../common/hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_INPUT_TYPE = {
  kspm: _constants.CLOUDBEAT_VANILLA,
  cspm: _constants.CLOUDBEAT_AWS,
  vuln_mgmt: _constants.CLOUDBEAT_VULN_MGMT_AWS
};
const EditScreenStepTitle = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.fleetIntegration.integrationSettingsTitle",
  defaultMessage: "Integration Settings"
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
const AWS_SINGLE_ACCOUNT = exports.AWS_SINGLE_ACCOUNT = 'single-account';
const AWS_ORGANIZATION_ACCOUNT = exports.AWS_ORGANIZATION_ACCOUNT = 'organization-account';
const GCP_SINGLE_ACCOUNT = exports.GCP_SINGLE_ACCOUNT = 'single-account';
const GCP_ORGANIZATION_ACCOUNT = exports.GCP_ORGANIZATION_ACCOUNT = 'organization-account';
const AZURE_SINGLE_ACCOUNT = exports.AZURE_SINGLE_ACCOUNT = 'single-account';
const AZURE_ORGANIZATION_ACCOUNT = exports.AZURE_ORGANIZATION_ACCOUNT = 'organization-account';
const getAwsAccountTypeOptions = isAwsOrgDisabled => [{
  id: AWS_ORGANIZATION_ACCOUNT,
  label: _i18n.i18n.translate('xpack.csp.fleetIntegration.awsAccountType.awsOrganizationLabel', {
    defaultMessage: 'AWS Organization'
  }),
  disabled: isAwsOrgDisabled,
  tooltip: isAwsOrgDisabled ? _i18n.i18n.translate('xpack.csp.fleetIntegration.awsAccountType.awsOrganizationDisabledTooltip', {
    defaultMessage: 'Supported from integration version 1.5.0 and above'
  }) : undefined,
  testId: 'awsOrganizationTestId'
}, {
  id: AWS_SINGLE_ACCOUNT,
  label: _i18n.i18n.translate('xpack.csp.fleetIntegration.awsAccountType.singleAccountLabel', {
    defaultMessage: 'Single Account'
  }),
  testId: 'awsSingleTestId'
}];
const getGcpAccountTypeOptions = isGcpOrgDisabled => [{
  id: GCP_ORGANIZATION_ACCOUNT,
  label: _i18n.i18n.translate('xpack.csp.fleetIntegration.gcpAccountType.gcpOrganizationLabel', {
    defaultMessage: 'GCP Organization'
  }),
  disabled: isGcpOrgDisabled,
  tooltip: isGcpOrgDisabled ? _i18n.i18n.translate('xpack.csp.fleetIntegration.gcpAccountType.gcpOrganizationDisabledTooltip', {
    defaultMessage: 'Supported from integration version 1.6.0 and above'
  }) : undefined,
  testId: 'gcpOrganizationAccountTestId'
}, {
  id: GCP_SINGLE_ACCOUNT,
  label: _i18n.i18n.translate('xpack.csp.fleetIntegration.gcpAccountType.gcpSingleAccountLabel', {
    defaultMessage: 'Single Project'
  }),
  testId: 'gcpSingleAccountTestId'
}];
const getAzureAccountTypeOptions = isAzureOrganizationDisabled => [{
  id: AZURE_ORGANIZATION_ACCOUNT,
  label: _i18n.i18n.translate('xpack.csp.fleetIntegration.azureAccountType.azureOrganizationLabel', {
    defaultMessage: 'Azure Organization'
  }),
  testId: 'azureOrganizationAccountTestId',
  disabled: isAzureOrganizationDisabled,
  tooltip: isAzureOrganizationDisabled ? _i18n.i18n.translate('xpack.csp.fleetIntegration.azureAccountType.azureOrganizationDisabledTooltip', {
    defaultMessage: 'Coming Soon'
  }) : undefined
}, {
  id: AZURE_SINGLE_ACCOUNT,
  label: _i18n.i18n.translate('xpack.csp.fleetIntegration.azureAccountType.singleAccountLabel', {
    defaultMessage: 'Single Subscription'
  }),
  testId: 'azureSingleAccountTestId'
}];
const getAwsAccountType = input => {
  var _input$streams$0$vars, _input$streams$0$vars2;
  return (_input$streams$0$vars = input.streams[0].vars) === null || _input$streams$0$vars === void 0 ? void 0 : (_input$streams$0$vars2 = _input$streams$0$vars['aws.account_type']) === null || _input$streams$0$vars2 === void 0 ? void 0 : _input$streams$0$vars2.value;
};
const AWS_ORG_MINIMUM_PACKAGE_VERSION = '1.5.0-preview20';
const AwsAccountTypeSelect = ({
  input,
  newPolicy,
  updatePolicy,
  packageInfo,
  disabled
}) => {
  // This will disable the aws org option for any version below 1.5.0-preview20 which introduced support for account_type. https://github.com/elastic/integrations/pull/6682
  const isValidSemantic = (0, _valid.default)(packageInfo.version);
  const isAwsOrgDisabled = isValidSemantic ? (0, _compare.default)(packageInfo.version, AWS_ORG_MINIMUM_PACKAGE_VERSION) < 0 : true;
  const awsAccountTypeOptions = (0, _react.useMemo)(() => getAwsAccountTypeOptions(isAwsOrgDisabled), [isAwsOrgDisabled]);
  (0, _react.useEffect)(() => {
    if (!getAwsAccountType(input)) {
      updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
        'aws.account_type': {
          value: isAwsOrgDisabled ? AWS_SINGLE_ACCOUNT : AWS_ORGANIZATION_ACCOUNT,
          type: 'text'
        }
      }));
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [input, updatePolicy]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.fleetIntegration.awsAccountTypeDescriptionLabel",
    defaultMessage: "Select between single account or organization, and then fill in the name and description to help identify this integration."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), isAwsOrgDisabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.fleetIntegration.awsAccountType.awsOrganizationNotSupportedMessage",
    defaultMessage: "AWS Organization not supported in current integration version. Please upgrade to the latest version to enable AWS Organizations integration."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_csp_boxed_radio_group.RadioGroup, {
    disabled: disabled,
    idSelected: getAwsAccountType(input) || '',
    options: awsAccountTypeOptions,
    onChange: accountType => {
      updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
        'aws.account_type': {
          value: accountType,
          type: 'text'
        }
      }));
    },
    size: "m",
    name: "awsAccountType"
  }), getAwsAccountType(input) === AWS_ORGANIZATION_ACCOUNT && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.fleetIntegration.awsAccountType.awsOrganizationDescription",
    defaultMessage: "Connect Elastic to every AWS Account (current and future) in your environment by providing Elastic with read-only (configuration) access to your AWS organization."
  }))), getAwsAccountType(input) === AWS_SINGLE_ACCOUNT && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.fleetIntegration.awsAccountType.singleAccountDescription",
    defaultMessage: "Deploying to a single account is suitable for an initial POC. To ensure complete coverage, it is strongly recommended to deploy CSPM at the organization-level, which automatically connects all accounts (both current and future)."
  }))));
};
const getGcpAccountType = input => {
  var _input$streams$0$vars3, _input$streams$0$vars4;
  return (_input$streams$0$vars3 = input.streams[0].vars) === null || _input$streams$0$vars3 === void 0 ? void 0 : (_input$streams$0$vars4 = _input$streams$0$vars3['gcp.account_type']) === null || _input$streams$0$vars4 === void 0 ? void 0 : _input$streams$0$vars4.value;
};
const GCP_ORG_MINIMUM_PACKAGE_VERSION = '1.6.0';
const GcpAccountTypeSelect = ({
  input,
  newPolicy,
  updatePolicy,
  packageInfo,
  disabled
}) => {
  // This will disable the gcp org option for any version below 1.6.0 which introduced support for account_type. https://github.com/elastic/integrations/pull/6682
  const validSemantic = (0, _valid.default)(packageInfo.version);
  const integrationVersionNumberOnly = (0, _coerce.default)(validSemantic) || '';
  const isGcpOrgDisabled = (0, _lt.default)(integrationVersionNumberOnly, GCP_ORG_MINIMUM_PACKAGE_VERSION);
  const gcpAccountTypeOptions = (0, _react.useMemo)(() => getGcpAccountTypeOptions(isGcpOrgDisabled), [isGcpOrgDisabled]);
  /* Create a subset of properties from GcpField to use for hiding value of Organization ID when switching account type from Organization to Single */
  const subsetOfGcpField = (({
    ['gcp.organization_id']: a
  }) => ({
    'gcp.organization_id': a
  }))(_gcp_credential_form.gcpField.fields);
  const fieldsToHide = (0, _gcp_credential_form.getInputVarsFields)(input, subsetOfGcpField);
  const fieldsSnapshot = (0, _react.useRef)({});
  const lastSetupAccessType = (0, _react.useRef)(undefined);
  const onSetupFormatChange = newSetupFormat => {
    if (newSetupFormat === 'single-account') {
      var _input$streams$0$vars5;
      // We need to store the current manual fields to restore them later
      fieldsSnapshot.current = Object.fromEntries(fieldsToHide.map(field => [field.id, {
        value: field.value
      }]));
      // We need to store the last manual credentials type to restore it later
      lastSetupAccessType.current = (_input$streams$0$vars5 = input.streams[0].vars) === null || _input$streams$0$vars5 === void 0 ? void 0 : _input$streams$0$vars5['gcp.account_type'].value;
      updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
        'gcp.account_type': {
          value: 'single-account',
          type: 'text'
        },
        // Clearing fields from previous setup format to prevent exposing credentials
        // when switching from manual to cloud formation
        ...Object.fromEntries(fieldsToHide.map(field => [field.id, {
          value: undefined
        }]))
      }));
    } else {
      updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
        'gcp.account_type': {
          // Restoring last manual credentials type
          value: lastSetupAccessType.current || 'organization-account',
          type: 'text'
        },
        // Restoring fields from manual setup format if any
        ...fieldsSnapshot.current
      }));
    }
  };
  (0, _react.useEffect)(() => {
    if (!getGcpAccountType(input)) {
      updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
        'gcp.account_type': {
          value: isGcpOrgDisabled ? GCP_SINGLE_ACCOUNT : GCP_ORGANIZATION_ACCOUNT,
          type: 'text'
        }
      }));
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [input, updatePolicy]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.fleetIntegration.gcpAccountTypeDescriptionLabel",
    defaultMessage: "Select between single project or organization, and then fill in the name and description to help identify this integration."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), isGcpOrgDisabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.fleetIntegration.gcpAccountType.gcpOrganizationNotSupportedMessage",
    defaultMessage: "GCP Organization not supported in current integration version. Please upgrade to the latest version to enable GCP Organizations integration."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_csp_boxed_radio_group.RadioGroup, {
    disabled: disabled,
    idSelected: getGcpAccountType(input) || '',
    options: gcpAccountTypeOptions,
    onChange: accountType => accountType !== getGcpAccountType(input) && onSetupFormatChange(accountType),
    size: "m",
    name: "accountType"
  }), getGcpAccountType(input) === GCP_ORGANIZATION_ACCOUNT && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.fleetIntegration.gcpAccountType.gcpOrganizationDescription",
    defaultMessage: "Connect Elastic to every GCP Project (current and future) in your environment by providing Elastic with read-only (configuration) access to your GCP organization"
  }))), getGcpAccountType(input) === GCP_SINGLE_ACCOUNT && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.fleetIntegration.gcpAccountType.gcpSingleAccountDescription",
    defaultMessage: "Deploying to a single project is suitable for an initial POC. To ensure complete coverage, it is strongly recommended to deploy CSPM at the organization-level, which automatically connects all projects (both current and future)."
  }))));
};
const getAzureAccountType = input => {
  var _input$streams$0$vars6, _input$streams$0$vars7;
  return (_input$streams$0$vars6 = input.streams[0].vars) === null || _input$streams$0$vars6 === void 0 ? void 0 : (_input$streams$0$vars7 = _input$streams$0$vars6['azure.account_type']) === null || _input$streams$0$vars7 === void 0 ? void 0 : _input$streams$0$vars7.value;
};
const AZURE_ORG_MINIMUM_PACKAGE_VERSION = '1.7.0';
const AzureAccountTypeSelect = ({
  input,
  newPolicy,
  updatePolicy,
  disabled,
  packageInfo,
  setupTechnology
}) => {
  const isAzureOrganizationDisabled = (0, _utils.isBelowMinVersion)(packageInfo.version, AZURE_ORG_MINIMUM_PACKAGE_VERSION);
  const azureAccountTypeOptions = getAzureAccountTypeOptions(isAzureOrganizationDisabled);
  const isAgentless = setupTechnology === _public.SetupTechnology.AGENTLESS;
  (0, _react.useEffect)(() => {
    if (!getAzureAccountType(input)) {
      updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
        'azure.account_type': {
          value: isAzureOrganizationDisabled ? AZURE_SINGLE_ACCOUNT : AZURE_ORGANIZATION_ACCOUNT,
          type: 'text'
        },
        'azure.credentials.type': {
          value: isAgentless ? _azure_credentials_form.AZURE_CREDENTIALS_TYPE.SERVICE_PRINCIPAL_WITH_CLIENT_SECRET : _azure_credentials_form.AZURE_CREDENTIALS_TYPE.ARM_TEMPLATE,
          type: 'text'
        }
      }));
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [input, updatePolicy]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.fleetIntegration.azureAccountTypeDescriptionLabel",
    defaultMessage: "Select between onboarding an Azure Organization (tenant root group) or a single Azure subscription, and then fill in the name and description to help identify this integration."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_csp_boxed_radio_group.RadioGroup, {
    disabled: disabled,
    idSelected: getAzureAccountType(input) || '',
    options: azureAccountTypeOptions,
    onChange: accountType => {
      updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, {
        'azure.account_type': {
          value: accountType,
          type: 'text'
        }
      }));
    },
    size: "m",
    name: "azureAccountType"
  }), getAzureAccountType(input) === AZURE_ORGANIZATION_ACCOUNT && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.fleetIntegration.azureAccountType.azureOrganizationDescription",
    defaultMessage: "Connect Elastic to every Azure Subscription (current and future) in your environment by providing Elastic with read-only (configuration) access to your Azure Organization (tenant root group)."
  }))), getAzureAccountType(input) === AZURE_SINGLE_ACCOUNT && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.fleetIntegration.azureAccountType.singleAccountDescription",
    defaultMessage: "Deploying to a single subscription is suitable for an initial POC. To ensure compete coverage, it is strongly recommended to deploy CSPM at the organization (tenant root group) level, which automatically connects all subscriptions (both current and future)."
  }))));
};
const IntegrationSettings = ({
  onChange,
  fields
}) => /*#__PURE__*/_react.default.createElement("div", null, fields.map(({
  value,
  id,
  label,
  error
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  key: id,
  id: id,
  fullWidth: true,
  label: label,
  isInvalid: !!error,
  error: error
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
  isInvalid: !!error,
  fullWidth: true,
  value: value,
  onChange: event => onChange(id, event.target.value)
}))));
const usePolicyTemplateInitialName = ({
  isEditPage,
  integration,
  newPolicy,
  packagePolicyList,
  updatePolicy,
  setCanFetchIntegration
}) => {
  (0, _react.useEffect)(() => {
    if (!integration) return;
    if (isEditPage) return;
    const packagePolicyListByIntegration = packagePolicyList === null || packagePolicyList === void 0 ? void 0 : packagePolicyList.filter(policy => {
      var _policy$vars, _policy$vars$posture;
      return (policy === null || policy === void 0 ? void 0 : (_policy$vars = policy.vars) === null || _policy$vars === void 0 ? void 0 : (_policy$vars$posture = _policy$vars.posture) === null || _policy$vars$posture === void 0 ? void 0 : _policy$vars$posture.value) === integration;
    });
    const currentIntegrationName = (0, _utils.getMaxPackageName)(integration, packagePolicyListByIntegration);

    /*
     * If 'packagePolicyListByIntegration' is undefined it means policies were still not feteched - Array.isArray(undefined) = false
     * if policie were fetched its an array - the check will return true
     */
    const isPoliciesLoaded = Array.isArray(packagePolicyListByIntegration);
    updatePolicy({
      ...newPolicy,
      name: currentIntegrationName
    }, isPoliciesLoaded);
    setCanFetchIntegration(false);
    // since this useEffect should only run on initial mount updatePolicy and newPolicy shouldn't re-trigger it
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [integration, isEditPage, packagePolicyList]);
};
const getSelectedOption = (options, policyTemplate = _cloudSecurityPostureCommon.CSPM_POLICY_TEMPLATE) => {
  // Looks for the enabled deployment (aka input). By default, all inputs are disabled.
  // Initial state when all inputs are disabled is to choose the first available of the relevant policyTemplate
  // Default selected policy template is CSPM
  const selectedOption = options.find(i => i.enabled) || options.find(i => i.policy_template === policyTemplate) || options[0];
  (0, _helpers.assert)(selectedOption, 'Failed to determine selected option'); // We can't provide a default input without knowing the policy template
  (0, _helpers.assert)((0, _utils.isPostureInput)(selectedOption), 'Unknown option: ' + selectedOption.type);
  return selectedOption;
};

/**
 * Update CloudFormation template and stack name in the Agent Policy
 * based on the selected policy template
 */
const useCloudFormationTemplate = ({
  packageInfo,
  newPolicy,
  updatePolicy
}) => {
  var _newPolicy$vars;
  (0, _react.useEffect)(() => {
    var _newPolicy$inputs, _newPolicy$inputs$fin, _newPolicy$inputs$fin2, _newPolicy$inputs$fin3;
    const templateUrl = (0, _utils.getVulnMgmtCloudFormationDefaultValue)(packageInfo);

    // If the template is not available, do not update the policy
    if (templateUrl === '') return;
    const checkCurrentTemplate = newPolicy === null || newPolicy === void 0 ? void 0 : (_newPolicy$inputs = newPolicy.inputs) === null || _newPolicy$inputs === void 0 ? void 0 : (_newPolicy$inputs$fin = _newPolicy$inputs.find(i => i.type === _constants.CLOUDBEAT_VULN_MGMT_AWS)) === null || _newPolicy$inputs$fin === void 0 ? void 0 : (_newPolicy$inputs$fin2 = _newPolicy$inputs$fin.config) === null || _newPolicy$inputs$fin2 === void 0 ? void 0 : (_newPolicy$inputs$fin3 = _newPolicy$inputs$fin2.cloud_formation_template_url) === null || _newPolicy$inputs$fin3 === void 0 ? void 0 : _newPolicy$inputs$fin3.value;

    // If the template is already set, do not update the policy
    if (checkCurrentTemplate === templateUrl) return;
    updatePolicy === null || updatePolicy === void 0 ? void 0 : updatePolicy({
      ...newPolicy,
      inputs: newPolicy.inputs.map(input => {
        if (input.type === _constants.CLOUDBEAT_VULN_MGMT_AWS) {
          return {
            ...input,
            config: {
              cloud_formation_template_url: {
                value: templateUrl
              }
            }
          };
        }
        return input;
      })
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [newPolicy === null || newPolicy === void 0 ? void 0 : (_newPolicy$vars = newPolicy.vars) === null || _newPolicy$vars === void 0 ? void 0 : _newPolicy$vars.cloud_formation_template_url, newPolicy, packageInfo]);
};
const CspPolicyTemplateForm = exports.default = exports.CspPolicyTemplateForm = /*#__PURE__*/(0, _react.memo)(({
  newPolicy,
  onChange,
  validationResults,
  isEditPage,
  packageInfo,
  handleSetupTechnologyChange,
  isAgentlessEnabled,
  defaultSetupTechnology,
  integrationToEnable,
  setIntegrationToEnable
}) => {
  const integrationParam = (0, _reactRouterDom.useParams)().integration;
  const integration = integrationToEnable && _constants.SUPPORTED_POLICY_TEMPLATES.includes(integrationToEnable) ? integrationToEnable : undefined;
  const isParentSecurityPosture = !integrationParam;

  // Handling validation state
  const [isValid, setIsValid] = (0, _react.useState)(true);
  const {
    cloud,
    uiSettings
  } = (0, _use_kibana.useKibana)().services;
  const cloudConnectorsEnabled = uiSettings.get(_managementSettingsIds.SECURITY_SOLUTION_ENABLE_CLOUD_CONNECTOR_SETTING) || false;
  const CLOUD_CONNECTOR_VERSION_ENABLED_ESS = '2.0.0-preview01';
  const isServerless = !!cloud.serverless.projectType;
  const input = getSelectedOption(newPolicy.inputs, integration);
  const getIsSubscriptionValid = (0, _use_is_subscription_status_valid.useIsSubscriptionStatusValid)();
  const isSubscriptionValid = !!getIsSubscriptionValid.data;
  const {
    isAgentlessAvailable,
    setupTechnology,
    updateSetupTechnology
  } = (0, _use_setup_technology.useSetupTechnology)({
    input,
    isAgentlessEnabled,
    handleSetupTechnologyChange,
    isEditPage,
    defaultSetupTechnology
  });
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const shouldRenderAgentlessSelector = !isEditPage && isAgentlessAvailable || isEditPage && isAgentlessEnabled;
  const getDefaultCloudCredentialsType = (isAgentless, inputType) => {
    const credentialsTypes = {
      'cloudbeat/cis_aws': (0, _utils.getCloudDefaultAwsCredentialConfig)({
        isAgentless,
        showCloudConnectors,
        packageInfo
      }),
      'cloudbeat/cis_gcp': {
        'gcp.credentials.type': {
          value: isAgentless ? _gcp_credential_form.GCP_CREDENTIALS_TYPE.CREDENTIALS_JSON : _gcp_credential_form.GCP_CREDENTIALS_TYPE.CREDENTIALS_NONE,
          type: 'text'
        }
      },
      'cloudbeat/cis_azure': {
        'azure.credentials.type': {
          value: isAgentless ? _azure_credentials_form.AZURE_CREDENTIALS_TYPE.SERVICE_PRINCIPAL_WITH_CLIENT_SECRET : _azure_credentials_form.AZURE_CREDENTIALS_TYPE.ARM_TEMPLATE,
          type: 'text'
        }
      }
    };
    return credentialsTypes[inputType];
  };
  const updatePolicy = (0, _react.useCallback)((updatedPolicy, isExtensionLoaded) => {
    onChange({
      isValid,
      updatedPolicy,
      isExtensionLoaded
    });
  }, [onChange, isValid]);
  const cloudConnectorRemoteRoleTemplate = (0, _utils.getCloudConnectorRemoteRoleTemplate)({
    input,
    cloud,
    packageInfo
  });
  const showCloudConnectors = cloudConnectorsEnabled && !!cloudConnectorRemoteRoleTemplate && (0, _gte.default)(packageInfo.version, CLOUD_CONNECTOR_VERSION_ENABLED_ESS);

  /**
   * - Updates policy inputs by user selection
   * - Updates hidden policy vars
   */
  const setEnabledPolicyInput = (0, _react.useCallback)(inputType => {
    const inputVars = (0, _utils.getPostureInputHiddenVars)(inputType, packageInfo, setupTechnology, showCloudConnectors);
    const policy = (0, _utils.getPosturePolicy)(newPolicy, inputType, inputVars);
    updatePolicy(policy);
  }, [packageInfo, newPolicy, setupTechnology, updatePolicy, showCloudConnectors]);

  // search for non null fields of the validation?.vars object
  const validationResultsNonNullFields = Object.keys((validationResults === null || validationResults === void 0 ? void 0 : validationResults.vars) || {}).filter(key => ((validationResults === null || validationResults === void 0 ? void 0 : validationResults.vars) || {})[key] !== null);
  const hasInvalidRequiredVars = !!(0, _utils.hasErrors)(validationResults);
  const [isLoading, setIsLoading] = (0, _react.useState)(validationResultsNonNullFields.length > 0);
  const [canFetchIntegration, setCanFetchIntegration] = (0, _react.useState)(true);

  // delaying component rendering due to a race condition issue from Fleet
  // TODO: remove this workaround when the following issue is resolved:
  // https://github.com/elastic/kibana/issues/153246
  (0, _react.useEffect)(() => {
    // using validation?.vars to know if the newPolicy state was reset due to race condition
    if (validationResultsNonNullFields.length > 0) {
      // Forcing rerender to recover from the validation errors state
      setIsLoading(true);
    }
    setTimeout(() => setIsLoading(false), 200);
  }, [validationResultsNonNullFields]);
  (0, _react.useEffect)(() => {
    setIsLoading(getIsSubscriptionValid.isLoading);
  }, [getIsSubscriptionValid.isLoading]);
  const {
    data: packagePolicyList,
    refetch
  } = (0, _use_package_policy_list.usePackagePolicyList)(packageInfo.name, {
    enabled: canFetchIntegration
  });
  (0, _react.useEffect)(() => {
    if (!isServerless) {
      setIsValid(isSubscriptionValid);
    }
  }, [isServerless, isSubscriptionValid]);
  (0, _react.useEffect)(() => {
    if (isEditPage) return;
    if (isLoading) return;
    // Pick default input type for policy template.
    // Only 1 enabled input is supported when all inputs are initially enabled.
    // Required for mount only to ensure a single input type is selected
    // This will remove errors in validationResults.vars
    setEnabledPolicyInput(DEFAULT_INPUT_TYPE[input.policy_template]);
    refetch();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isLoading, input.policy_template, isEditPage]);
  (0, _react.useEffect)(() => {
    if (isEditPage) {
      return;
    }
    setEnabledPolicyInput(input.type);
    setIntegrationToEnable === null || setIntegrationToEnable === void 0 ? void 0 : setIntegrationToEnable(input.policy_template);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [setupTechnology]);
  useCloudFormationTemplate({
    packageInfo,
    updatePolicy,
    newPolicy
  });
  usePolicyTemplateInitialName({
    packagePolicyList: packagePolicyList === null || packagePolicyList === void 0 ? void 0 : packagePolicyList.items,
    isEditPage,
    integration: integration,
    newPolicy,
    updatePolicy,
    setCanFetchIntegration
  });
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceAround",
      "data-test-subj": _utils.POLICY_TEMPLATE_FORM_DTS.LOADER
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl"
    })));
  }
  const integrationFields = [{
    id: 'name',
    value: newPolicy.name,
    error: (validationResults === null || validationResults === void 0 ? void 0 : validationResults.name) || null,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.fleetIntegration.integrationNameLabel",
      defaultMessage: "Name"
    })
  }, {
    id: 'description',
    value: newPolicy.description || '',
    error: (validationResults === null || validationResults === void 0 ? void 0 : validationResults.description) || null,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.fleetIntegration.integrationDescriptionLabel",
      defaultMessage: "Description"
    })
  }];
  if (!getIsSubscriptionValid.isLoading && !isSubscriptionValid) {
    return /*#__PURE__*/_react.default.createElement(_subscription_not_allowed.SubscriptionNotAllowed, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isEditPage && /*#__PURE__*/_react.default.createElement(EditScreenStepTitle, null), isParentSecurityPosture && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_policy_template_selectors.PolicyTemplateSelector, {
    selectedTemplate: input.policy_template,
    policy: newPolicy,
    setPolicyTemplate: template => {
      setEnabledPolicyInput(DEFAULT_INPUT_TYPE[template]);
      setIntegrationToEnable === null || setIntegrationToEnable === void 0 ? void 0 : setIntegrationToEnable(template);
    },
    disabled: isEditPage
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), isEditPage && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.csp.fleetIntegration.editWarning.calloutTitle', {
      defaultMessage: 'Modifying Integration Details'
    }),
    color: "warning",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.fleetIntegration.editWarning.calloutDescription",
    defaultMessage: "In order to change the cloud service provider (CSP) you want to monitor, add more accounts, or change where CSPM is deployed (Organization vs Single Account), please add a new CSPM integration."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_policy_template_selectors.PolicyTemplateInfo, {
    postureType: input.policy_template
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), input.type === 'cloudbeat/vuln_mgmt_aws' ? null : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_policy_template_selectors.PolicyTemplateInputSelector, {
    input: input,
    setInput: setEnabledPolicyInput,
    disabled: isEditPage
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), input.type === 'cloudbeat/cis_aws' && /*#__PURE__*/_react.default.createElement(AwsAccountTypeSelect, {
    input: input,
    newPolicy: newPolicy,
    updatePolicy: updatePolicy,
    packageInfo: packageInfo,
    disabled: isEditPage
  }), input.type === 'cloudbeat/cis_gcp' && /*#__PURE__*/_react.default.createElement(GcpAccountTypeSelect, {
    input: input,
    newPolicy: newPolicy,
    updatePolicy: updatePolicy,
    packageInfo: packageInfo,
    disabled: isEditPage
  }), input.type === 'cloudbeat/cis_azure' && /*#__PURE__*/_react.default.createElement(AzureAccountTypeSelect, {
    input: input,
    newPolicy: newPolicy,
    updatePolicy: updatePolicy,
    packageInfo: packageInfo,
    disabled: isEditPage,
    setupTechnology: setupTechnology
  }), input.type === 'cloudbeat/vuln_mgmt_aws' ? null : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(IntegrationSettings, {
    fields: integrationFields,
    onChange: (field, value) => updatePolicy({
      ...newPolicy,
      [field]: value
    })
  }), !input.type.includes('vuln_mgmt') && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "advancedOptions",
    "data-test-subj": "advancedOptionsAccordion",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: euiTheme.colors.textPrimary,
      css: {
        fontWeight: euiTheme.font.weight.medium
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.fleetIntegration.advancedOptionsLabel",
      defaultMessage: "Advanced options"
    })),
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_public.NamespaceComboBox, {
    fullWidth: true,
    namespace: newPolicy.namespace,
    placeholder: "default",
    isEditPage: isEditPage,
    validationError: validationResults === null || validationResults === void 0 ? void 0 : validationResults.namespace,
    onNamespaceChange: namespace => {
      updatePolicy({
        ...newPolicy,
        namespace
      });
    },
    "data-test-subj": "namespaceInput",
    labelId: "xpack.csp.fleetIntegration.namespaceLabel",
    helpTextId: "xpack.csp.fleetIntegration.awsAccountType.awsOrganizationDescription"
  }))), shouldRenderAgentlessSelector && /*#__PURE__*/_react.default.createElement(_setup_technology_selector.SetupTechnologySelector, {
    showLimitationsMessage: !isServerless,
    disabled: isEditPage,
    setupTechnology: setupTechnology,
    isAgentless: !!(newPolicy !== null && newPolicy !== void 0 && newPolicy.supports_agentless),
    onSetupTechnologyChange: value => {
      updateSetupTechnology(value);
      updatePolicy((0, _utils.getPosturePolicy)(newPolicy, input.type, getDefaultCloudCredentialsType(value === _public.SetupTechnology.AGENTLESS, input.type)));
    }
  }), /*#__PURE__*/_react.default.createElement(_policy_template_selectors.PolicyTemplateVarsForm, {
    input: input,
    newPolicy: newPolicy,
    updatePolicy: updatePolicy,
    packageInfo: packageInfo,
    onChange: onChange,
    setIsValid: setIsValid,
    disabled: isEditPage,
    setupTechnology: setupTechnology,
    isEditPage: isEditPage,
    hasInvalidRequiredVars: hasInvalidRequiredVars,
    showCloudConnectors: showCloudConnectors
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
});
CspPolicyTemplateForm.displayName = 'CspPolicyTemplateForm';

// eslint-disable-next-line import/no-default-export