"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.groupAlertsByRule = void 0;
var _domain = require("../../../common/types/domain");
var _get_rule_id_from_event = require("./get_rule_id_from_event");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const groupAlertsByRule = items => {
  const attachmentsByRule = items.reduce((acc, item) => {
    const rule = (0, _get_rule_id_from_event.getRuleIdFromEvent)(item);
    if (!acc[rule.id]) {
      acc[rule.id] = {
        alertId: [],
        index: [],
        type: _domain.AttachmentType.alert,
        rule
      };
    }
    const alerts = acc[rule.id].alertId;
    const indexes = acc[rule.id].index;
    if (Array.isArray(alerts) && Array.isArray(indexes)) {
      var _item$ecs$_id, _item$ecs$_index;
      alerts.push((_item$ecs$_id = item.ecs._id) !== null && _item$ecs$_id !== void 0 ? _item$ecs$_id : '');
      indexes.push((_item$ecs$_index = item.ecs._index) !== null && _item$ecs$_index !== void 0 ? _item$ecs$_index : '');
    }
    return acc;
  }, {});
  return Object.values(attachmentsByRule);
};
exports.groupAlertsByRule = groupAlertsByRule;