"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tag = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Tag = ({
  name,
  color = '#666666',
  type = 'health',
  ...rest
}) => {
  switch (type) {
    case 'health':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, (0, _extends2.default)({
        color: color
      }, rest), name);
    case 'badge':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, (0, _extends2.default)({
        color: color
      }, rest), name);
  }
};
exports.Tag = Tag;
Tag.propTypes = {
  name: _propTypes.default.string.isRequired,
  color: _propTypes.default.string,
  type: _propTypes.default.string
};