"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApiPathsWithDescriptions = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getApiPathsWithDescriptions = apiSpec => {
  const pathMap = {};
  const pathObjs = apiSpec === null || apiSpec === void 0 ? void 0 : apiSpec.getPaths();
  if (pathObjs) {
    for (const [path, pathObj] of Object.entries(pathObjs)) {
      if (pathObj !== null && pathObj !== void 0 && pathObj.get) {
        var _pathObj$get, _pathObj$get2;
        pathMap[path] = (pathObj === null || pathObj === void 0 ? void 0 : (_pathObj$get = pathObj.get) === null || _pathObj$get === void 0 ? void 0 : _pathObj$get.getDescription()) || (pathObj === null || pathObj === void 0 ? void 0 : (_pathObj$get2 = pathObj.get) === null || _pathObj$get2 === void 0 ? void 0 : _pathObj$get2.getSummary());
      }
    }
  }
  return pathMap;
};
exports.getApiPathsWithDescriptions = getApiPathsWithDescriptions;