"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createApmSourcesAccessService = createApmSourcesAccessService;
exports.registerServices = registerServices;
var _api = require("./api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerServices(params) {
  return createApmSourcesAccessService(params);
}
function createApmSourcesAccessService({
  http
}) {
  const getApmIndexSettings = options => (0, _api.callSourcesAPI)(http, 'GET /internal/apm-sources/settings/apm-index-settings', options);
  const getApmIndices = options => (0, _api.callSourcesAPI)(http, 'GET /internal/apm-sources/settings/apm-indices', options);
  const saveApmIndices = options => (0, _api.callSourcesAPI)(http, 'POST /internal/apm-sources/settings/apm-indices/save', options);
  const apmSourcesService = {
    getApmIndices,
    getApmIndexSettings,
    saveApmIndices
  };
  return apmSourcesService;
}