"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BandedAccessorType = void 0;
exports.isPointGeometry = isPointGeometry;
exports.isBarGeometry = isBarGeometry;
exports.getGeometryHighlightState = getGeometryHighlightState;
exports.isDimmed = isDimmed;
exports.BandedAccessorType = Object.freeze({
    Y0: 'y0',
    Y1: 'y1',
});
function isPointGeometry(ig) {
    return ig.hasOwnProperty('radius');
}
function isBarGeometry(ig) {
    return ig.hasOwnProperty('width') && ig.hasOwnProperty('height');
}
function getGeometryHighlightState(key, highlightedLegendItem) {
    return !highlightedLegendItem
        ? 'default'
        : highlightedLegendItem.seriesIdentifiers.some((si) => si.key === key)
            ? 'focused'
            : 'dimmed';
}
function isDimmed(state) {
    return state === 'dimmed';
}
//# sourceMappingURL=geometry.js.map