/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.slowlog;

import java.util.Map;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexingSlowLog;
import org.elasticsearch.index.SearchSlowLog;
import org.elasticsearch.index.SlowLogFieldProvider;
import org.elasticsearch.index.SlowLogFields;
import org.elasticsearch.xpack.security.Security;

public class SecuritySlowLogFieldProvider
implements SlowLogFieldProvider {
    private final Security plugin;

    public SecuritySlowLogFieldProvider() {
        throw new IllegalStateException("Provider must be constructed using PluginsService");
    }

    public SecuritySlowLogFieldProvider(Security plugin) {
        this.plugin = plugin;
    }

    public SlowLogFields create(IndexSettings indexSettings) {
        return new SecuritySlowLogFields(indexSettings);
    }

    public SlowLogFields create() {
        return new SecuritySlowLogFields();
    }

    private class SecuritySlowLogFields
    implements SlowLogFields {
        private boolean includeUserInIndexing = false;
        private boolean includeUserInSearch = false;

        SecuritySlowLogFields(IndexSettings indexSettings) {
            indexSettings.getScopedSettings().addSettingsUpdateConsumer(SearchSlowLog.INDEX_SEARCH_SLOWLOG_INCLUDE_USER_SETTING, newValue -> {
                this.includeUserInSearch = newValue;
            });
            this.includeUserInSearch = (Boolean)indexSettings.getValue(SearchSlowLog.INDEX_SEARCH_SLOWLOG_INCLUDE_USER_SETTING);
            indexSettings.getScopedSettings().addSettingsUpdateConsumer(IndexingSlowLog.INDEX_INDEXING_SLOWLOG_INCLUDE_USER_SETTING, newValue -> {
                this.includeUserInIndexing = newValue;
            });
            this.includeUserInIndexing = (Boolean)indexSettings.getValue(IndexingSlowLog.INDEX_INDEXING_SLOWLOG_INCLUDE_USER_SETTING);
        }

        SecuritySlowLogFields() {
        }

        public Map<String, String> indexFields() {
            if (this.includeUserInIndexing) {
                return SecuritySlowLogFieldProvider.this.plugin.getAuthContextForSlowLog();
            }
            return Map.of();
        }

        public Map<String, String> searchFields() {
            if (this.includeUserInSearch) {
                return SecuritySlowLogFieldProvider.this.plugin.getAuthContextForSlowLog();
            }
            return Map.of();
        }

        public Map<String, String> queryFields() {
            return SecuritySlowLogFieldProvider.this.plugin.getAuthContextForSlowLog();
        }
    }
}

