/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.interceptor;

import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.permission.DocumentPermissions;
import org.elasticsearch.xpack.security.authz.interceptor.FieldAndDocumentLevelSecurityRequestInterceptor;

public class ShardSearchRequestInterceptor
extends FieldAndDocumentLevelSecurityRequestInterceptor {
    private static final Logger logger = LogManager.getLogger(ShardSearchRequestInterceptor.class);

    public ShardSearchRequestInterceptor(ThreadPool threadPool, XPackLicenseState licenseState) {
        super(threadPool.getThreadContext(), licenseState);
    }

    @Override
    void disableFeatures(IndicesRequest indicesRequest, Map<String, IndicesAccessControl.IndexAccessControl> indexAccessControlByIndex, ActionListener<Void> listener) {
        ShardSearchRequest request = (ShardSearchRequest)indicesRequest;
        if (ShardSearchRequestInterceptor.dlsUsesStoredScripts(request, indexAccessControlByIndex)) {
            logger.debug("Disable shard search request cache because DLS queries use stored scripts");
            request.requestCache(Boolean.valueOf(false));
        }
        listener.onResponse(null);
    }

    @Override
    String[] requestIndices(IndicesRequest indicesRequest) {
        ShardSearchRequest request = (ShardSearchRequest)indicesRequest;
        return new String[]{request.shardId().getIndexName()};
    }

    @Override
    public boolean supports(IndicesRequest request) {
        return request instanceof ShardSearchRequest;
    }

    static boolean dlsUsesStoredScripts(ShardSearchRequest request, Map<String, IndicesAccessControl.IndexAccessControl> indexAccessControlByIndex) {
        String indexName = request.shardId().getIndexName();
        IndicesAccessControl.IndexAccessControl indexAccessControl = indexAccessControlByIndex.get(indexName);
        assert (indexAccessControl != null) : "index access control cannot be null";
        DocumentPermissions documentPermissions = indexAccessControl.getDocumentPermissions();
        if (documentPermissions.hasDocumentLevelPermissions()) {
            try {
                return documentPermissions.hasStoredScript();
            }
            catch (IOException e) {
                throw new ElasticsearchException((Throwable)e);
            }
        }
        return false;
    }
}

