/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.querydsl.query;

import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.esql.core.querydsl.query.NotQuery;
import org.elasticsearch.xpack.esql.core.tree.Source;

public abstract class Query {
    public static final float NO_SCORE_BOOST = 0.0f;
    private final Source source;

    protected Query(Source source) {
        if (source == null) {
            throw new IllegalArgumentException("location must be specified");
        }
        this.source = source;
    }

    public Source source() {
        return this.source;
    }

    public final QueryBuilder toQueryBuilder() {
        QueryBuilder builder = this.asBuilder();
        if (!this.scorable()) {
            builder = Query.unscore(builder);
        }
        return builder;
    }

    protected abstract QueryBuilder asBuilder();

    protected abstract String innerToString();

    public abstract boolean containsPlan();

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Query other = (Query)obj;
        return this.source.equals(other.source);
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + String.valueOf(this.source) + "[" + this.innerToString() + "]";
    }

    public Query negate(Source source) {
        return new NotQuery(source, this);
    }

    public boolean scorable() {
        return false;
    }

    public static QueryBuilder unscore(QueryBuilder builder) {
        return builder.boost(0.0f);
    }
}

