/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.Random;
import java.util.TreeSet;
import org.elasticsearch.Build;
import org.elasticsearch.Version;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.core.Nullable;

public class VersionUtils {
    private static final NavigableSet<Version> ALL_VERSIONS = Collections.unmodifiableNavigableSet(new TreeSet(Version.getDeclaredVersions(Version.class)));

    public static NavigableSet<Version> allVersions() {
        return ALL_VERSIONS;
    }

    public static Version getPreviousVersion(Version version) {
        NavigableSet<Version> versions = ALL_VERSIONS.headSet(version, false);
        if (versions.isEmpty()) {
            throw new IllegalArgumentException("couldn't find any versions before [" + String.valueOf(version) + "]");
        }
        return (Version)versions.getLast();
    }

    public static Version getPreviousVersion() {
        Version version = VersionUtils.getPreviousVersion(Version.CURRENT);
        assert (version.before((VersionId)Version.CURRENT));
        return version;
    }

    public static Version getPreviousMinorVersion() {
        for (Version v : ALL_VERSIONS.descendingSet()) {
            if (v.minor >= Version.CURRENT.minor && v.major >= Version.CURRENT.major) continue;
            return v;
        }
        throw new IllegalArgumentException("couldn't find any versions of the minor before [" + Build.current().version() + "]");
    }

    public static Version getFirstVersion() {
        return (Version)ALL_VERSIONS.getFirst();
    }

    public static Version randomVersion(Random random) {
        return VersionUtils.randomFrom(random, ALL_VERSIONS);
    }

    public static Version randomCompatibleVersion(Random random, Version version) {
        List<Version> compatible = ALL_VERSIONS.stream().filter(arg_0 -> ((Version)version).isCompatible(arg_0)).toList();
        return compatible.get(random.nextInt(compatible.size()));
    }

    public static Version randomVersionBetween(Random random, @Nullable Version minVersion, @Nullable Version maxVersion) {
        if (minVersion != null && maxVersion != null && maxVersion.before((VersionId)minVersion)) {
            throw new IllegalArgumentException("maxVersion [" + String.valueOf(maxVersion) + "] cannot be less than minVersion [" + String.valueOf(minVersion) + "]");
        }
        NavigableSet<Version> versions = ALL_VERSIONS;
        if (minVersion != null) {
            if (!versions.contains(minVersion)) {
                throw new IllegalArgumentException("minVersion [" + String.valueOf(minVersion) + "] does not exist.");
            }
            versions = versions.tailSet(minVersion, true);
        }
        if (maxVersion != null) {
            if (!versions.contains(maxVersion)) {
                throw new IllegalArgumentException("maxVersion [" + String.valueOf(maxVersion) + "] does not exist.");
            }
            versions = versions.headSet(maxVersion, true);
        }
        return VersionUtils.randomFrom(random, versions);
    }

    public static Version maxCompatibleVersion(Version version) {
        return ALL_VERSIONS.tailSet(version, true).descendingSet().stream().filter(arg_0 -> ((Version)version).isCompatible(arg_0)).findFirst().orElseThrow();
    }

    public static <T extends VersionId<T>> T randomFrom(Random random, NavigableSet<T> set) {
        return (T)((VersionId)RandomPicks.randomFrom((Random)random, set));
    }
}

