/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.SeedUtils;
import com.carrotsearch.randomizedtesting.generators.RandomNumbers;
import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import com.carrotsearch.randomizedtesting.generators.RandomStrings;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.admin.cluster.configuration.AddVotingConfigExclusionsRequest;
import org.elasticsearch.action.admin.cluster.configuration.ClearVotingConfigExclusionsRequest;
import org.elasticsearch.action.admin.cluster.configuration.TransportAddVotingConfigExclusionsAction;
import org.elasticsearch.action.admin.cluster.configuration.TransportClearVotingConfigExclusionsAction;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequestBuilder;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NodeConnectionsService;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.cluster.coordination.ClusterBootstrapService;
import org.elasticsearch.cluster.coordination.NoMasterBlockService;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRouting;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.OperationRouting;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.cluster.routing.allocation.decider.ThrottlingAllocationDecider;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.MockSecureSettings;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Predicates;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.ShardLockObtainFailedException;
import org.elasticsearch.gateway.PersistedClusterStateService;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexingPressure;
import org.elasticsearch.index.engine.DocIdSeqNoAndSource;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineTestCase;
import org.elasticsearch.index.engine.InternalEngine;
import org.elasticsearch.index.seqno.SeqNoStats;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardTestCase;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.HierarchyCircuitBreakerService;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCache;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.node.MockNode;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeService;
import org.elasticsearch.node.NodeValidationException;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.test.ClusterServiceUtils;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.NodeConfigurationSource;
import org.elasticsearch.test.NodeRoles;
import org.elasticsearch.test.TestCluster;
import org.elasticsearch.test.disruption.ServiceDisruptionScheme;
import org.elasticsearch.test.transport.MockTransportService;
import org.elasticsearch.transport.Compression;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.TransportSettings;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public final class InternalTestCluster
extends TestCluster {
    private static final Logger logger = LogManager.getLogger(InternalTestCluster.class);
    private static final Predicate<NodeAndClient> DATA_NODE_PREDICATE = new Predicate<NodeAndClient>(){

        @Override
        public boolean test(NodeAndClient nodeAndClient) {
            return DiscoveryNode.canContainData((Settings)nodeAndClient.node.settings());
        }

        public String toString() {
            return "any data node";
        }
    };
    private static final Predicate<NodeAndClient> MASTER_NODE_PREDICATE = new Predicate<NodeAndClient>(){

        @Override
        public boolean test(NodeAndClient nodeAndClient) {
            return DiscoveryNode.isMasterNode((Settings)nodeAndClient.node.settings());
        }

        public String toString() {
            return "any master-eligible node";
        }
    };
    private static final Predicate<NodeAndClient> NO_DATA_NO_MASTER_PREDICATE = DATA_NODE_PREDICATE.negate().and(MASTER_NODE_PREDICATE.negate());
    public static final int DEFAULT_LOW_NUM_MASTER_NODES = 1;
    public static final int DEFAULT_HIGH_NUM_MASTER_NODES = 3;
    static final int DEFAULT_MIN_NUM_DATA_NODES = 1;
    static final int DEFAULT_MAX_NUM_DATA_NODES = LuceneTestCase.TEST_NIGHTLY ? 6 : 3;
    static final int DEFAULT_NUM_CLIENT_NODES = -1;
    static final int DEFAULT_MIN_NUM_CLIENT_NODES = 0;
    static final int DEFAULT_MAX_NUM_CLIENT_NODES = 1;
    private volatile NavigableMap<String, NodeAndClient> nodes = Collections.emptyNavigableMap();
    private final Set<Path> dataDirToClean = new HashSet<Path>();
    private final String clusterName;
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final Settings defaultSettings;
    private final AtomicInteger nextNodeId = new AtomicInteger(0);
    private final long[] sharedNodesSeeds;
    private final int numSharedDedicatedMasterNodes;
    private final int numSharedDataNodes;
    private final int numSharedCoordOnlyNodes;
    private final NodeConfigurationSource nodeConfigurationSource;
    private final boolean autoManageMasterNodes;
    private final Collection<Class<? extends Plugin>> mockPlugins;
    private final boolean forbidPrivateIndexSettings;
    private final int numDataPaths;
    private final String nodePrefix;
    private final Path baseDir;
    private ServiceDisruptionScheme activeDisruptionScheme;
    private final Function<Client, Client> clientWrapper;
    private final boolean autoManageVotingExclusions;
    public static final int BOOTSTRAP_MASTER_NODE_INDEX_AUTO = -1;
    public static final int BOOTSTRAP_MASTER_NODE_INDEX_DONE = -2;
    private int bootstrapMasterNodeIndex = -1;
    private final EntitledNodePathsProvider entitledNodePathsProvider;
    private final Object discoveryFileMutex = new Object();
    public static final RestartCallback EMPTY_CALLBACK = new RestartCallback();

    public InternalTestCluster(long clusterSeed, Path baseDir, boolean randomlyAddDedicatedMasters, boolean autoManageMasterNodes, int minNumDataNodes, int maxNumDataNodes, String clusterName, NodeConfigurationSource nodeConfigurationSource, int numClientNodes, String nodePrefix, Collection<Class<? extends Plugin>> mockPlugins, Function<Client, Client> clientWrapper, EntitledNodePathsProvider entitledNodePathsProvider) {
        this(clusterSeed, baseDir, randomlyAddDedicatedMasters, autoManageMasterNodes, minNumDataNodes, maxNumDataNodes, clusterName, nodeConfigurationSource, numClientNodes, nodePrefix, mockPlugins, clientWrapper, true, false, true, entitledNodePathsProvider);
    }

    public InternalTestCluster(long clusterSeed, Path baseDir, boolean randomlyAddDedicatedMasters, boolean autoManageMasterNodes, int minNumDataNodes, int maxNumDataNodes, String clusterName, NodeConfigurationSource nodeConfigurationSource, int numClientNodes, String nodePrefix, Collection<Class<? extends Plugin>> mockPlugins, Function<Client, Client> clientWrapper, boolean forbidPrivateIndexSettings, boolean forceSingleDataPath, boolean autoManageVotingExclusions, EntitledNodePathsProvider entitledNodePathsProvider) {
        super(clusterSeed);
        this.autoManageMasterNodes = autoManageMasterNodes;
        this.clientWrapper = clientWrapper;
        this.forbidPrivateIndexSettings = forbidPrivateIndexSettings;
        this.baseDir = baseDir;
        this.clusterName = clusterName;
        this.autoManageVotingExclusions = autoManageVotingExclusions;
        this.entitledNodePathsProvider = entitledNodePathsProvider;
        if (minNumDataNodes < 0 || maxNumDataNodes < 0) {
            throw new IllegalArgumentException("minimum and maximum number of data nodes must be >= 0");
        }
        if (maxNumDataNodes < minNumDataNodes) {
            throw new IllegalArgumentException("maximum number of data nodes must be >= minimum number of  data nodes");
        }
        Random random = new Random(clusterSeed);
        boolean useDedicatedMasterNodes = randomlyAddDedicatedMasters && random.nextBoolean();
        this.numSharedDataNodes = RandomNumbers.randomIntBetween((Random)random, (int)minNumDataNodes, (int)maxNumDataNodes);
        assert (this.numSharedDataNodes >= 0);
        if (this.numSharedDataNodes == 0) {
            this.numSharedCoordOnlyNodes = 0;
            this.numSharedDedicatedMasterNodes = 0;
        } else {
            this.numSharedDedicatedMasterNodes = useDedicatedMasterNodes ? (random.nextBoolean() ? 1 : 3) : 0;
            this.numSharedCoordOnlyNodes = numClientNodes < 0 ? RandomNumbers.randomIntBetween((Random)random, (int)0, (int)1) : numClientNodes;
        }
        assert (this.numSharedCoordOnlyNodes >= 0);
        this.nodePrefix = nodePrefix;
        assert (nodePrefix != null);
        this.mockPlugins = mockPlugins;
        this.sharedNodesSeeds = new long[this.numSharedDedicatedMasterNodes + this.numSharedDataNodes + this.numSharedCoordOnlyNodes];
        for (int i = 0; i < this.sharedNodesSeeds.length; ++i) {
            this.sharedNodesSeeds[i] = random.nextLong();
        }
        logger.info("Setup InternalTestCluster [{}] with seed [{}] using [{}] dedicated masters, [{}] (data) nodes and [{}] coord only nodes (master nodes are [{}])", (Object)clusterName, (Object)SeedUtils.formatSeed((long)clusterSeed), (Object)this.numSharedDedicatedMasterNodes, (Object)this.numSharedDataNodes, (Object)this.numSharedCoordOnlyNodes, (Object)(autoManageMasterNodes ? "auto-managed" : "manual"));
        this.nodeConfigurationSource = nodeConfigurationSource;
        this.numDataPaths = forceSingleDataPath || random.nextDouble() < 0.8 ? 1 : RandomNumbers.randomIntBetween((Random)random, (int)2, (int)4);
        Settings.Builder builder = Settings.builder();
        builder.put(Environment.PATH_HOME_SETTING.getKey(), baseDir);
        builder.put(Environment.PATH_REPO_SETTING.getKey(), baseDir.resolve("repos"));
        builder.put(TransportSettings.PORT.getKey(), ESTestCase.getPortRange());
        builder.put("http.port", ESTestCase.getPortRange());
        if (Strings.hasLength((String)System.getProperty("tests.es.logger.level"))) {
            builder.put("logger.level", System.getProperty("tests.es.logger.level"));
        }
        builder.put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING.getKey(), "1b");
        builder.put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_HIGH_DISK_WATERMARK_SETTING.getKey(), "1b");
        builder.put(DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING.getKey(), "1b");
        builder.put(OperationRouting.USE_ADAPTIVE_REPLICA_SELECTION_SETTING.getKey(), random.nextBoolean());
        if (LuceneTestCase.TEST_NIGHTLY) {
            builder.put(ThrottlingAllocationDecider.CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_INCOMING_RECOVERIES_SETTING.getKey(), RandomNumbers.randomIntBetween((Random)random, (int)5, (int)10));
            builder.put(ThrottlingAllocationDecider.CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_OUTGOING_RECOVERIES_SETTING.getKey(), RandomNumbers.randomIntBetween((Random)random, (int)5, (int)10));
        } else if (random.nextInt(100) <= 90) {
            builder.put(ThrottlingAllocationDecider.CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_INCOMING_RECOVERIES_SETTING.getKey(), RandomNumbers.randomIntBetween((Random)random, (int)2, (int)5));
            builder.put(ThrottlingAllocationDecider.CLUSTER_ROUTING_ALLOCATION_NODE_CONCURRENT_OUTGOING_RECOVERIES_SETTING.getKey(), RandomNumbers.randomIntBetween((Random)random, (int)2, (int)5));
        }
        builder.put(RecoverySettings.INDICES_RECOVERY_RETRY_DELAY_STATE_SYNC_SETTING.getKey(), TimeValue.timeValueMillis((long)RandomNumbers.randomIntBetween((Random)random, (int)20, (int)50)));
        builder.put(RecoverySettings.INDICES_RECOVERY_MAX_CONCURRENT_FILE_CHUNKS_SETTING.getKey(), RandomNumbers.randomIntBetween((Random)random, (int)1, (int)5));
        builder.put(RecoverySettings.INDICES_RECOVERY_MAX_CONCURRENT_OPERATIONS_SETTING.getKey(), RandomNumbers.randomIntBetween((Random)random, (int)1, (int)4));
        builder.put(NoMasterBlockService.NO_MASTER_BLOCK_SETTING.getKey(), ESTestCase.randomFrom(random, new String[]{"write", "metadata_write"}));
        builder.put(DestructiveOperations.REQUIRES_NAME_SETTING.getKey(), false);
        this.defaultSettings = builder.build();
    }

    public void setBootstrapMasterNodeIndex(int bootstrapMasterNodeIndex) {
        assert (!this.autoManageMasterNodes || bootstrapMasterNodeIndex == -1) : "bootstrapMasterNodeIndex should be BOOTSTRAP_MASTER_NODE_INDEX_AUTO if autoManageMasterNodes is true, but was " + bootstrapMasterNodeIndex;
        this.bootstrapMasterNodeIndex = bootstrapMasterNodeIndex;
    }

    @Override
    public String getClusterName() {
        return this.clusterName;
    }

    public String[] getNodeNames() {
        return this.nodes.keySet().toArray(Strings.EMPTY_ARRAY);
    }

    private Settings getSettings(int nodeOrdinal, long nodeSeed, Settings others) {
        Settings.Builder builder = Settings.builder().put(this.defaultSettings).put(InternalTestCluster.getRandomNodeSettings(nodeSeed));
        Settings settings = this.nodeConfigurationSource.nodeSettings(nodeOrdinal, others);
        if (settings != null) {
            if (settings.get(ClusterName.CLUSTER_NAME_SETTING.getKey()) != null) {
                throw new IllegalStateException("Tests must not set a '" + ClusterName.CLUSTER_NAME_SETTING.getKey() + "' as a node setting set '" + ClusterName.CLUSTER_NAME_SETTING.getKey() + "': [" + settings.get(ClusterName.CLUSTER_NAME_SETTING.getKey()) + "]");
            }
            builder.put(settings);
        }
        if (others != null) {
            builder.put(others);
        }
        builder.put(ClusterName.CLUSTER_NAME_SETTING.getKey(), this.clusterName);
        return builder.build();
    }

    public Collection<Class<? extends Plugin>> getPlugins() {
        HashSet<Class<? extends Plugin>> plugins = new HashSet<Class<? extends Plugin>>(this.nodeConfigurationSource.nodePlugins());
        plugins.addAll(this.mockPlugins);
        return plugins;
    }

    private static Settings getRandomNodeSettings(long seed) {
        Random random = new Random(seed);
        Settings.Builder builder = Settings.builder();
        if (LuceneTestCase.rarely((Random)random)) {
            builder.put(TransportSettings.TRANSPORT_COMPRESS.getKey(), (Enum)Compression.Enabled.TRUE);
        } else if (random.nextBoolean()) {
            builder.put(TransportSettings.TRANSPORT_COMPRESS.getKey(), (Enum)Compression.Enabled.FALSE);
        } else {
            builder.put(TransportSettings.TRANSPORT_COMPRESS.getKey(), (Enum)Compression.Enabled.INDEXING_DATA);
        }
        if (random.nextBoolean()) {
            builder.put(TransportSettings.TRANSPORT_COMPRESSION_SCHEME.getKey(), (Enum)Compression.Scheme.DEFLATE);
        } else {
            builder.put(TransportSettings.TRANSPORT_COMPRESSION_SCHEME.getKey(), (Enum)Compression.Scheme.LZ4);
        }
        if (random.nextBoolean()) {
            builder.put("cache.recycler.page.type", (Enum)RandomPicks.randomFrom((Random)random, (Object[])PageCacheRecycler.Type.values()));
        }
        if (random.nextInt(10) == 0) {
            builder.put(SearchService.KEEPALIVE_INTERVAL_SETTING.getKey(), TimeValue.timeValueMillis((long)(10 + random.nextInt(2000))).getStringRep());
        } else if (random.nextInt(10) != 0) {
            builder.put(SearchService.KEEPALIVE_INTERVAL_SETTING.getKey(), TimeValue.timeValueSeconds((long)(10 + random.nextInt(300))).getStringRep());
        }
        if (random.nextBoolean()) {
            builder.put(SearchService.DEFAULT_KEEPALIVE_SETTING.getKey(), TimeValue.timeValueSeconds((long)(100 + random.nextInt(300))).getStringRep());
        }
        builder.put(EsExecutors.NODE_PROCESSORS_SETTING.getKey(), RandomNumbers.randomIntBetween((Random)random, (int)1, (int)Math.min(4, Runtime.getRuntime().availableProcessors())));
        if (random.nextBoolean() && random.nextBoolean()) {
            builder.put("indices.fielddata.cache.size", (long)(1 + random.nextInt(1000)), ByteSizeUnit.MB);
        }
        builder.put(TransportSettings.RST_ON_CLOSE.getKey(), true);
        if (random.nextBoolean()) {
            builder.put(TransportSettings.CONNECTIONS_PER_NODE_RECOVERY.getKey(), random.nextInt(2) + 1);
            builder.put(TransportSettings.CONNECTIONS_PER_NODE_BULK.getKey(), random.nextInt(3) + 1);
            builder.put(TransportSettings.CONNECTIONS_PER_NODE_REG.getKey(), random.nextInt(6) + 1);
        }
        if (random.nextBoolean()) {
            builder.put(MappingUpdatedAction.INDICES_MAPPING_DYNAMIC_TIMEOUT_SETTING.getKey(), TimeValue.timeValueSeconds((long)RandomNumbers.randomIntBetween((Random)random, (int)10, (int)30)).getStringRep());
            builder.put(MappingUpdatedAction.INDICES_MAX_IN_FLIGHT_UPDATES_SETTING.getKey(), RandomNumbers.randomIntBetween((Random)random, (int)1, (int)10));
        }
        builder.put(HierarchyCircuitBreakerService.USE_REAL_MEMORY_USAGE_SETTING.getKey(), false);
        if (random.nextInt(10) == 0) {
            builder.put(HierarchyCircuitBreakerService.REQUEST_CIRCUIT_BREAKER_TYPE_SETTING.getKey(), "noop");
            builder.put(HierarchyCircuitBreakerService.FIELDDATA_CIRCUIT_BREAKER_TYPE_SETTING.getKey(), "noop");
        }
        if (random.nextBoolean()) {
            if (random.nextInt(10) == 0) {
                builder.put(RecoverySettings.INDICES_RECOVERY_MAX_BYTES_PER_SEC_SETTING.getKey(), ByteSizeValue.of((long)RandomNumbers.randomIntBetween((Random)random, (int)1, (int)10), (ByteSizeUnit)ByteSizeUnit.MB));
            } else {
                builder.put(RecoverySettings.INDICES_RECOVERY_MAX_BYTES_PER_SEC_SETTING.getKey(), ByteSizeValue.of((long)RandomNumbers.randomIntBetween((Random)random, (int)10, (int)200), (ByteSizeUnit)ByteSizeUnit.MB));
            }
        }
        if (random.nextBoolean()) {
            builder.put(TransportSettings.PING_SCHEDULE.getKey(), RandomNumbers.randomIntBetween((Random)random, (int)100, (int)2000) + "ms");
        }
        if (random.nextBoolean()) {
            builder.put(ScriptService.SCRIPT_GENERAL_CACHE_SIZE_SETTING.getKey(), RandomNumbers.randomIntBetween((Random)random, (int)0, (int)2000));
        }
        if (random.nextBoolean()) {
            builder.put(ScriptService.SCRIPT_GENERAL_CACHE_EXPIRE_SETTING.getKey(), TimeValue.timeValueMillis((long)RandomNumbers.randomIntBetween((Random)random, (int)750, (int)10000000)).getStringRep());
        }
        if (random.nextBoolean()) {
            int initialMillisBound = RandomNumbers.randomIntBetween((Random)random, (int)10, (int)100);
            builder.put(TransportReplicationAction.REPLICATION_INITIAL_RETRY_BACKOFF_BOUND.getKey(), TimeValue.timeValueMillis((long)initialMillisBound));
            int retryTimeoutSeconds = RandomNumbers.randomIntBetween((Random)random, (int)0, (int)60);
            builder.put(TransportReplicationAction.REPLICATION_RETRY_TIMEOUT.getKey(), TimeValue.timeValueSeconds((long)retryTimeoutSeconds));
        }
        if (random.nextInt(10) == 0) {
            builder.put(PersistedClusterStateService.DOCUMENT_PAGE_SIZE.getKey(), ByteSizeValue.ofBytes((long)RandomNumbers.randomIntBetween((Random)random, (int)(LuceneTestCase.rarely((Random)random) ? 10 : 100), (int)ESTestCase.randomFrom(random, new Integer[]{1000, 10000, 100000, 1000000}))));
        }
        if (random.nextBoolean()) {
            builder.put(Node.INITIAL_STATE_TIMEOUT_SETTING.getKey(), "0s");
        }
        return builder.build();
    }

    public static String clusterName(String prefix, long clusterSeed) {
        StringBuilder builder = new StringBuilder(prefix);
        builder.append("-TEST_WORKER_VM=[").append(ESTestCase.TEST_WORKER_VM_ID).append(']');
        builder.append("-CLUSTER_SEED=[").append(clusterSeed).append(']');
        builder.append("-HASH=[").append(SeedUtils.formatSeed((long)System.nanoTime())).append(']');
        return builder.toString();
    }

    private void ensureOpen() {
        if (!this.open.get()) {
            throw new RuntimeException("Cluster is already closed");
        }
    }

    private NodeAndClient getOrBuildRandomNode() {
        assert (Thread.holdsLock(this));
        NodeAndClient randomNodeAndClient = this.getRandomNodeAndClient();
        if (randomNodeAndClient != null) {
            return randomNodeAndClient;
        }
        Runnable onTransportServiceStarted = () -> {};
        int nodeId = this.nextNodeId.getAndIncrement();
        Settings settings = this.getNodeSettings(nodeId, this.random.nextLong(), Settings.EMPTY);
        Settings nodeSettings = Settings.builder().putList(ClusterBootstrapService.INITIAL_MASTER_NODES_SETTING.getKey(), new String[]{(String)Node.NODE_NAME_SETTING.get(settings)}).put(settings).build();
        NodeAndClient buildNode = this.buildNode(nodeId, nodeSettings, false, onTransportServiceStarted);
        assert (this.nodes.isEmpty());
        buildNode.startNode();
        this.publishNode(buildNode);
        return buildNode;
    }

    private NodeAndClient getRandomNodeAndClient() {
        NavigableMap<String, NodeAndClient> n = this.nodes;
        this.ensureOpen();
        if (n.isEmpty()) {
            return null;
        }
        return (NodeAndClient)ESTestCase.randomFrom(n.values());
    }

    private NodeAndClient getRandomNodeAndClient(Predicate<NodeAndClient> predicate) {
        List values = this.nodes.values().stream().filter(predicate).collect(Collectors.toList());
        this.ensureOpen();
        if (!values.isEmpty()) {
            return (NodeAndClient)ESTestCase.randomFrom(this.random, values);
        }
        return null;
    }

    public synchronized void ensureAtLeastNumDataNodes(int n) {
        int size = this.numDataNodes();
        if (size < n) {
            logger.info("increasing cluster size from {} to {}", (Object)size, (Object)n);
            if (this.numSharedDedicatedMasterNodes > 0) {
                this.startDataOnlyNodes(n - size);
            } else {
                this.startNodes(n - size);
            }
            this.validateClusterFormed();
        }
    }

    public synchronized void ensureAtMostNumDataNodes(int n) throws IOException {
        int size = this.numDataNodes();
        if (size <= n) {
            return;
        }
        Stream collection = n == 0 ? this.nodes.values().stream() : this.nodes.values().stream().filter(DATA_NODE_PREDICATE.and(new NodeNamePredicate(this.getMasterName()).negate()));
        Iterator values = collection.iterator();
        logger.info("changing cluster size from {} data nodes to {}", (Object)size, (Object)n);
        HashSet<NodeAndClient> nodesToRemove = new HashSet<NodeAndClient>();
        int numNodesAndClients = 0;
        while (values.hasNext() && numNodesAndClients++ < size - n) {
            NodeAndClient next = (NodeAndClient)values.next();
            nodesToRemove.add(next);
        }
        this.stopNodesAndClients(nodesToRemove);
        if (!nodesToRemove.isEmpty() && this.size() > 0) {
            this.validateClusterFormed();
        }
    }

    private Settings getNodeSettings(int nodeId, long seed, Settings extraSettings) {
        Settings settings = this.getSettings(nodeId, seed, extraSettings);
        String name = this.buildNodeName(nodeId, settings);
        Settings.Builder updatedSettings = Settings.builder();
        updatedSettings.put(Environment.PATH_HOME_SETTING.getKey(), this.baseDir);
        if (this.numDataPaths > 1) {
            updatedSettings.putList(Environment.PATH_DATA_SETTING.getKey(), IntStream.range(0, this.numDataPaths).mapToObj(i -> this.baseDir.resolve(name).resolve("d" + i).toString()).collect(Collectors.toList()));
        } else {
            updatedSettings.put(Environment.PATH_DATA_SETTING.getKey(), this.baseDir.resolve(name));
        }
        updatedSettings.put(Environment.PATH_SHARED_DATA_SETTING.getKey(), this.baseDir.resolve(name + "-shared"));
        updatedSettings.put(settings);
        updatedSettings.put("node.name", name);
        updatedSettings.put(NodeEnvironment.NODE_ID_SEED_SETTING.getKey(), seed);
        return updatedSettings.build();
    }

    private synchronized NodeAndClient buildNode(int nodeId, Settings settings, boolean reuseExisting, final Runnable onTransportServiceStarted) {
        assert (Thread.holdsLock(this));
        this.ensureOpen();
        Collection<Class<? extends Plugin>> plugins = this.getPlugins();
        String name = settings.get("node.name");
        NodeAndClient nodeAndClient = (NodeAndClient)this.nodes.get(name);
        if (reuseExisting && nodeAndClient != null) {
            onTransportServiceStarted.run();
            return nodeAndClient;
        }
        assert (reuseExisting || nodeAndClient == null) : "node name [" + name + "] already exists but not allowed to use it";
        SecureSettings secureSettings = Settings.builder().put(settings).getSecureSettings();
        if (secureSettings instanceof MockSecureSettings) {
            secureSettings = ((MockSecureSettings)secureSettings).clone();
        }
        Path configPath = this.nodeConfigurationSource.nodeConfigPath(nodeId);
        MockNode node = new MockNode(settings, plugins, configPath, this.forbidPrivateIndexSettings, this.entitledNodePathsProvider.addEntitledNodePaths(settings, configPath));
        ((TransportService)node.injector().getInstance(TransportService.class)).addLifecycleListener(new LifecycleListener(this){

            public void afterStart() {
                onTransportServiceStarted.run();
            }
        });
        try {
            IOUtils.close((Closeable)secureSettings);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new NodeAndClient(name, node, settings, nodeId);
    }

    private String getNodePrefix(Settings settings) {
        return this.nodePrefix + InternalTestCluster.getRoleSuffix(settings);
    }

    private String buildNodeName(int id, Settings settings) {
        return this.getNodePrefix(settings) + id;
    }

    private static String getRoleSuffix(Settings settings) {
        Object suffix = "";
        if (settings.hasValue("nodes.roles")) {
            if (DiscoveryNode.hasRole((Settings)settings, (DiscoveryNodeRole)DiscoveryNodeRole.MASTER_ROLE)) {
                suffix = (String)suffix + DiscoveryNodeRole.MASTER_ROLE.roleNameAbbreviation();
            }
            if (DiscoveryNode.canContainData((Settings)settings)) {
                suffix = (String)suffix + DiscoveryNodeRole.DATA_ROLE.roleNameAbbreviation();
            }
            if (!DiscoveryNode.hasRole((Settings)settings, (DiscoveryNodeRole)DiscoveryNodeRole.MASTER_ROLE) && !DiscoveryNode.canContainData((Settings)settings)) {
                suffix = (String)suffix + "c";
            }
        }
        return suffix;
    }

    @Override
    public Client client() {
        NodeAndClient c = this.getRandomNodeAndClient();
        if (c == null) {
            throw new AssertionError((Object)"Unable to get client, no node found");
        }
        this.ensureOpen();
        return c.client();
    }

    public Client dataNodeClient() {
        return this.getRandomNodeAndClient(DATA_NODE_PREDICATE).client();
    }

    public Client masterClient() {
        NodeAndClient randomNodeAndClient = this.getRandomNodeAndClient(new NodeNamePredicate(this.getMasterName()));
        if (randomNodeAndClient != null) {
            return randomNodeAndClient.nodeClient();
        }
        throw new AssertionError((Object)"No master client found");
    }

    public Client nonMasterClient() {
        NodeAndClient randomNodeAndClient = this.getRandomNodeAndClient(new NodeNamePredicate(this.getMasterName()).negate());
        if (randomNodeAndClient != null) {
            return randomNodeAndClient.nodeClient();
        }
        throw new AssertionError((Object)"No non-master client found");
    }

    public synchronized Client coordOnlyNodeClient() {
        this.ensureOpen();
        NodeAndClient randomNodeAndClient = this.getRandomNodeAndClient(NO_DATA_NO_MASTER_PREDICATE);
        if (randomNodeAndClient != null) {
            return randomNodeAndClient.client();
        }
        int nodeId = this.nextNodeId.getAndIncrement();
        Settings settings = this.getSettings(nodeId, this.random.nextLong(), Settings.EMPTY);
        this.startCoordinatingOnlyNode(settings);
        return this.getRandomNodeAndClient(NO_DATA_NO_MASTER_PREDICATE).client();
    }

    public synchronized String startCoordinatingOnlyNode(Settings settings) {
        this.ensureOpen();
        return this.startNode(NodeRoles.noRoles(settings));
    }

    public Client client(String nodeName) {
        NodeAndClient nodeAndClient = (NodeAndClient)this.nodes.get(nodeName);
        if (nodeAndClient != null) {
            return nodeAndClient.client();
        }
        throw new AssertionError((Object)("No node found with name: [" + nodeName + "]"));
    }

    public Client smartClient() {
        NodeAndClient randomNodeAndClient = this.getRandomNodeAndClient();
        if (randomNodeAndClient != null) {
            return randomNodeAndClient.nodeClient();
        }
        throw new AssertionError((Object)"No smart client found");
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.open.compareAndSet(true, false)) {
            if (this.activeDisruptionScheme != null) {
                this.activeDisruptionScheme.testClusterClosed();
                this.activeDisruptionScheme = null;
            }
            Logger nodeConnectionLogger = LogManager.getLogger(NodeConnectionsService.class);
            Level initialLogLevel = nodeConnectionLogger.getLevel();
            Loggers.setLevel((Logger)nodeConnectionLogger, (Level)Level.ERROR);
            try {
                IOUtils.close(this.nodes.values());
            }
            finally {
                this.nodes = Collections.emptyNavigableMap();
                Loggers.setLevel((Logger)nodeConnectionLogger, (Level)initialLogLevel);
            }
        }
    }

    @Override
    public synchronized void beforeTest(Random random) throws IOException, InterruptedException {
        super.beforeTest(random);
        this.reset(true);
    }

    private synchronized void reset(boolean wipeData) throws IOException {
        Settings otherSettings;
        int i;
        for (NodeAndClient nodeAndClient : this.nodes.values()) {
            TransportService transportService = (TransportService)nodeAndClient.node.injector().getInstance(TransportService.class);
            if (!(transportService instanceof MockTransportService)) continue;
            MockTransportService mockTransportService = (MockTransportService)transportService;
            mockTransportService.clearAllRules();
        }
        this.randomlyResetClients();
        int newSize = this.sharedNodesSeeds.length;
        if (this.nextNodeId.get() == newSize && this.nodes.size() == newSize) {
            if (wipeData) {
                this.wipePendingDataDirectories();
            }
            logger.debug("Cluster hasn't changed - moving out - nodes: [{}] nextNodeId: [{}] numSharedNodes: [{}]", this.nodes.keySet(), (Object)this.nextNodeId.get(), (Object)newSize);
            return;
        }
        logger.debug("Cluster is NOT consistent - restarting shared nodes - nodes: [{}] nextNodeId: [{}] numSharedNodes: [{}]", this.nodes.keySet(), (Object)this.nextNodeId.get(), (Object)newSize);
        ArrayList<NodeAndClient> toClose = new ArrayList<NodeAndClient>();
        for (NodeAndClient nodeAndClient : this.nodes.values()) {
            if (nodeAndClient.nodeAndClientId() < this.sharedNodesSeeds.length) continue;
            logger.debug("Close Node [{}] not shared", (Object)nodeAndClient.name);
            toClose.add(nodeAndClient);
        }
        this.stopNodesAndClients(toClose);
        if (wipeData) {
            this.wipePendingDataDirectories();
        }
        ESTestCase.assertTrue((String)("expected at least one master-eligible node left in " + String.valueOf(this.nodes)), (this.nodes.isEmpty() || this.nodes.values().stream().anyMatch(NodeAndClient::isMasterEligible) ? 1 : 0) != 0);
        int prevNodeCount = this.nodes.size();
        assert (newSize == this.numSharedDedicatedMasterNodes + this.numSharedDataNodes + this.numSharedCoordOnlyNodes);
        ArrayList<NodeAndClient> toStartAndPublish = new ArrayList<NodeAndClient>();
        Runnable onTransportServiceStarted = () -> this.rebuildUnicastHostFiles(toStartAndPublish);
        ArrayList<Settings> settings = new ArrayList<Settings>();
        for (i = 0; i < this.numSharedDedicatedMasterNodes; ++i) {
            otherSettings = NodeRoles.nonDataNode();
            Settings nodeSettings = this.getNodeSettings(i, this.sharedNodesSeeds[i], otherSettings);
            settings.add(nodeSettings);
        }
        for (i = this.numSharedDedicatedMasterNodes; i < this.numSharedDedicatedMasterNodes + this.numSharedDataNodes; ++i) {
            otherSettings = this.numSharedDedicatedMasterNodes > 0 ? NodeRoles.removeRoles(Set.of(DiscoveryNodeRole.MASTER_ROLE)) : Settings.EMPTY;
            settings.add(this.getNodeSettings(i, this.sharedNodesSeeds[i], otherSettings));
        }
        for (i = this.numSharedDedicatedMasterNodes + this.numSharedDataNodes; i < this.numSharedDedicatedMasterNodes + this.numSharedDataNodes + this.numSharedCoordOnlyNodes; ++i) {
            Settings.Builder extraSettings = Settings.builder().put(NodeRoles.noRoles());
            settings.add(this.getNodeSettings(i, this.sharedNodesSeeds[i], extraSettings.build()));
        }
        int autoBootstrapMasterNodeIndex = -1;
        List masterNodeNames = settings.stream().filter(DiscoveryNode::isMasterNode).map(arg_0 -> ((Setting)Node.NODE_NAME_SETTING).get(arg_0)).collect(Collectors.toList());
        if (prevNodeCount == 0 && this.autoManageMasterNodes) {
            if (this.numSharedDedicatedMasterNodes > 0) {
                autoBootstrapMasterNodeIndex = RandomNumbers.randomIntBetween((Random)this.random, (int)0, (int)(this.numSharedDedicatedMasterNodes - 1));
            } else if (this.numSharedDataNodes > 0) {
                autoBootstrapMasterNodeIndex = RandomNumbers.randomIntBetween((Random)this.random, (int)0, (int)(this.numSharedDataNodes - 1));
            }
        }
        List<Settings> updatedSettings = this.bootstrapMasterNodeWithSpecifiedIndex(settings);
        for (int i2 = 0; i2 < this.numSharedDedicatedMasterNodes + this.numSharedDataNodes + this.numSharedCoordOnlyNodes; ++i2) {
            Settings nodeSettings = updatedSettings.get(i2);
            if (i2 == autoBootstrapMasterNodeIndex) {
                nodeSettings = Settings.builder().putList(ClusterBootstrapService.INITIAL_MASTER_NODES_SETTING.getKey(), masterNodeNames).put(nodeSettings).build();
            }
            NodeAndClient nodeAndClient = this.buildNode(i2, nodeSettings, true, onTransportServiceStarted);
            toStartAndPublish.add(nodeAndClient);
        }
        this.startAndPublishNodesAndClients(toStartAndPublish);
        this.nextNodeId.set(newSize);
        assert (this.size() == newSize);
        if (this.autoManageMasterNodes && newSize > 0) {
            this.validateClusterFormed();
        }
        logger.debug("Cluster is consistent again - nodes: [{}] nextNodeId: [{}] numSharedNodes: [{}]", this.nodes.keySet(), (Object)this.nextNodeId.get(), (Object)newSize);
    }

    public synchronized void validateClusterFormed() {
        HashSet<DiscoveryNode> expectedNodes = new HashSet<DiscoveryNode>();
        for (NodeAndClient nodeAndClient : this.nodes.values()) {
            expectedNodes.add(InternalTestCluster.getInstanceFromNode(ClusterService.class, nodeAndClient.node()).localNode());
        }
        logger.trace("validating cluster formed, expecting {}", expectedNodes);
        try {
            ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
                try {
                    boolean timeout = ((ClusterHealthResponse)this.client().admin().cluster().prepareHealth(ESTestCase.TEST_REQUEST_TIMEOUT, new String[0]).setWaitForEvents(Priority.LANGUID).setWaitForNodes(Integer.toString(expectedNodes.size())).get(TimeValue.timeValueSeconds((long)40L))).isTimedOut();
                    if (timeout) {
                        throw new IllegalStateException("timed out waiting for cluster to form");
                    }
                }
                catch (UnavailableShardsException e) {
                    if (e.getMessage() != null && e.getMessage().contains(".security")) {
                        throw new AssertionError((Object)e);
                    }
                    throw e;
                }
            }), 30L, TimeUnit.SECONDS);
            Object[] previousStates = new Object[1];
            ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
                List<ClusterState> states = this.nodes.values().stream().map(node -> InternalTestCluster.getInstanceFromNode(ClusterService.class, node.node())).map(ClusterService::state).toList();
                if (previousStates[0] != null && previousStates[0].equals(states)) {
                    throw new AssertionError((Object)"unchanged");
                }
                previousStates[0] = states;
                Supplier<String> debugString = () -> ", expected nodes: " + String.valueOf(expectedNodes) + " and actual cluster states " + String.valueOf(states);
                assert (states.stream().allMatch(cs -> cs.nodes().getMasterNodeId() != null)) : "Missing master" + debugString.get();
                assert (1L == states.stream().mapToLong(ClusterState::term).distinct().count()) : "Not all masters in same term" + debugString.get();
                states.forEach(cs -> {
                    DiscoveryNodes discoveryNodes = cs.nodes();
                    assert (expectedNodes.size() == discoveryNodes.getSize()) : "Node size mismatch" + (String)debugString.get();
                    for (DiscoveryNode expectedNode : expectedNodes) {
                        assert (discoveryNodes.nodeExists(expectedNode)) : "Expected node to exist: " + String.valueOf(expectedNode) + (String)debugString.get();
                    }
                });
            }), 30L, TimeUnit.SECONDS);
        }
        catch (AssertionError ae) {
            throw new IllegalStateException("cluster failed to form", (Throwable)((Object)ae));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public synchronized void afterTest() {
        this.wipePendingDataDirectories();
        this.randomlyResetClients();
    }

    @Override
    public void beforeIndexDeletion() throws Exception {
        this.assertNoPendingIndexOperations();
        this.assertAllPendingWriteLimitsReleased();
        this.assertOpenTranslogReferences();
        this.assertNoAcquiredIndexCommit();
    }

    private void assertAllPendingWriteLimitsReleased() throws Exception {
        ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            for (NodeAndClient nodeAndClient : this.nodes.values()) {
                IndexingPressure indexingPressure = this.getInstance(IndexingPressure.class, nodeAndClient.name);
                long combinedBytes = indexingPressure.stats().getCurrentCombinedCoordinatingAndPrimaryBytes();
                if (combinedBytes > 0L) {
                    throw new AssertionError((Object)("pending combined bytes [" + combinedBytes + "] bytes on node [" + nodeAndClient.name + "]."));
                }
                long coordinatingBytes = indexingPressure.stats().getCurrentCoordinatingBytes();
                if (coordinatingBytes > 0L) {
                    throw new AssertionError((Object)("pending coordinating bytes [" + coordinatingBytes + "] bytes on node [" + nodeAndClient.name + "]."));
                }
                long primaryBytes = indexingPressure.stats().getCurrentPrimaryBytes();
                if (primaryBytes > 0L) {
                    throw new AssertionError((Object)("pending primary bytes [" + primaryBytes + "] bytes on node [" + nodeAndClient.name + "]."));
                }
                long replicaWriteBytes = indexingPressure.stats().getCurrentReplicaBytes();
                if (replicaWriteBytes > 0L) {
                    throw new AssertionError((Object)("pending replica write bytes [" + combinedBytes + "] bytes on node [" + nodeAndClient.name + "]."));
                }
            }
        }), 60L, TimeUnit.SECONDS);
    }

    private void assertNoPendingIndexOperations() throws Exception {
        ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            for (NodeAndClient nodeAndClient : this.nodes.values()) {
                IndicesService indexServices = this.getInstance(IndicesService.class, nodeAndClient.name);
                for (IndexService indexService : indexServices) {
                    for (IndexShard indexShard : indexService) {
                        Assert.assertEquals((long)0L, (long)indexShard.getActiveOperationsCount());
                    }
                }
            }
        }), 60L, TimeUnit.SECONDS);
    }

    private void assertOpenTranslogReferences() throws Exception {
        ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            for (NodeAndClient nodeAndClient : this.nodes.values()) {
                IndicesService indexServices = this.getInstance(IndicesService.class, nodeAndClient.name);
                for (IndexService indexService : indexServices) {
                    for (IndexShard indexShard : indexService) {
                        try {
                            if (!(IndexShardTestCase.getEngine(indexShard) instanceof InternalEngine)) continue;
                            IndexShardTestCase.getTranslog(indexShard).getDeletionPolicy().assertNoOpenTranslogRefs();
                        }
                        catch (AlreadyClosedException alreadyClosedException) {}
                    }
                }
            }
        }), 60L, TimeUnit.SECONDS);
    }

    private void assertNoAcquiredIndexCommit() throws Exception {
        ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            for (NodeAndClient nodeAndClient : this.nodes.values()) {
                IndicesService indexServices = this.getInstance(IndicesService.class, nodeAndClient.name);
                for (IndexService indexService : indexServices) {
                    for (IndexShard indexShard : indexService) {
                        try {
                            Engine engine = IndexShardTestCase.getEngine(indexShard);
                            if (!(engine instanceof InternalEngine)) continue;
                            ESTestCase.assertFalse((String)(indexShard.routingEntry().toString() + " has unreleased snapshotted index commits"), (boolean)EngineTestCase.hasAcquiredIndexCommitsForTesting(engine));
                        }
                        catch (AlreadyClosedException alreadyClosedException) {}
                    }
                }
            }
        }), 60L, TimeUnit.SECONDS);
    }

    public void assertConsistentHistoryBetweenTranslogAndLuceneIndex() throws IOException {
        for (NodeAndClient nodeAndClient : this.nodes.values()) {
            IndicesService indexServices = this.getInstance(IndicesService.class, nodeAndClient.name);
            for (IndexService indexService : indexServices) {
                for (IndexShard indexShard : indexService) {
                    try {
                        IndexShardTestCase.assertConsistentHistoryBetweenTranslogAndLucene(indexShard);
                    }
                    catch (AlreadyClosedException alreadyClosedException) {}
                }
            }
        }
    }

    public void assertMergeExecutorIsDone() throws Exception {
        ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            for (String nodeName : this.getNodeNames()) {
                IndicesService indicesService = this.getInstance(IndicesService.class, nodeName);
                if (indicesService.getThreadPoolMergeExecutorService() == null) continue;
                ESTestCase.assertTrue((String)"thread pool merge executor is not done after test", (boolean)indicesService.getThreadPoolMergeExecutorService().allDone());
            }
        }));
    }

    public void assertNoInFlightDocsInEngine() throws Exception {
        ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            for (String nodeName : this.getNodeNames()) {
                IndicesService indexServices = this.getInstance(IndicesService.class, nodeName);
                for (IndexService indexService : indexServices) {
                    for (IndexShard indexShard : indexService) {
                        try {
                            Engine engine = IndexShardTestCase.getEngine(indexShard);
                            Assert.assertThat((String)indexShard.routingEntry().toString(), (Object)EngineTestCase.getInFlightDocCount(engine), (Matcher)Matchers.equalTo((Object)0L));
                        }
                        catch (AlreadyClosedException alreadyClosedException) {}
                    }
                }
            }
        }));
    }

    private IndexShard getShardOrNull(ClusterState clusterState, ShardRouting shardRouting) {
        if (shardRouting == null || !shardRouting.assignedToNode()) {
            return null;
        }
        DiscoveryNode assignedNode = clusterState.nodes().get(shardRouting.currentNodeId());
        if (assignedNode == null) {
            return null;
        }
        return (IndexShard)this.getInstance(IndicesService.class, assignedNode.getName()).getShardOrNull(shardRouting.shardId());
    }

    public void assertSeqNos() throws Exception {
        ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            ClusterState state = this.clusterService().state();
            for (IndexRoutingTable indexRoutingTable : state.routingTable().indicesRouting().values()) {
                for (int i = 0; i < indexRoutingTable.size(); ++i) {
                    Map syncGlobalCheckpoints;
                    SeqNoStats primarySeqNoStats;
                    IndexShardRoutingTable indexShardRoutingTable = indexRoutingTable.shard(i);
                    ShardRouting primaryShardRouting = indexShardRoutingTable.primaryShard();
                    IndexShard primaryShard = this.getShardOrNull(state, primaryShardRouting);
                    if (primaryShard == null) continue;
                    try {
                        primarySeqNoStats = primaryShard.seqNoStats();
                        syncGlobalCheckpoints = primaryShard.getInSyncGlobalCheckpoints();
                    }
                    catch (AlreadyClosedException ex) {
                        continue;
                    }
                    Assert.assertThat((String)(String.valueOf(primaryShardRouting) + " should have set the global checkpoint"), (Object)primarySeqNoStats.getGlobalCheckpoint(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)-2L)));
                    for (ShardRouting replicaShardRouting : indexShardRoutingTable.replicaShards()) {
                        SeqNoStats seqNoStats;
                        IndexShard replicaShard = this.getShardOrNull(state, replicaShardRouting);
                        if (replicaShard == null) continue;
                        try {
                            seqNoStats = replicaShard.seqNoStats();
                        }
                        catch (AlreadyClosedException e) {
                            continue;
                        }
                        Assert.assertThat((String)(String.valueOf(replicaShardRouting) + " seq_no_stats mismatch"), (Object)seqNoStats, (Matcher)Matchers.equalTo((Object)primarySeqNoStats));
                        Assert.assertThat((String)(String.valueOf(replicaShardRouting) + " global checkpoint syncs mismatch"), (Object)seqNoStats.getGlobalCheckpoint(), (Matcher)Matchers.equalTo((Object)((Long)syncGlobalCheckpoints.get(replicaShardRouting.allocationId().getId()))));
                    }
                }
            }
        }), 30L, TimeUnit.SECONDS);
    }

    public void assertSameDocIdsOnShards() throws Exception {
        ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            ClusterState state = ((ClusterStateResponse)this.client().admin().cluster().prepareState(ESTestCase.TEST_REQUEST_TIMEOUT).get()).getState();
            for (IndexRoutingTable indexRoutingTable : state.routingTable().indicesRouting().values()) {
                for (int i = 0; i < indexRoutingTable.size(); ++i) {
                    List<DocIdSeqNoAndSource> docsOnPrimary;
                    IndexShardRoutingTable indexShardRoutingTable = indexRoutingTable.shard(i);
                    ShardRouting primaryShardRouting = indexShardRoutingTable.primaryShard();
                    IndexShard primaryShard = this.getShardOrNull(state, primaryShardRouting);
                    if (primaryShard == null) continue;
                    try {
                        docsOnPrimary = IndexShardTestCase.getDocIdAndSeqNos(primaryShard);
                    }
                    catch (AlreadyClosedException ex) {
                        continue;
                    }
                    for (ShardRouting replicaShardRouting : indexShardRoutingTable.replicaShards()) {
                        List<DocIdSeqNoAndSource> docsOnReplica;
                        IndexShard replicaShard = this.getShardOrNull(state, replicaShardRouting);
                        if (replicaShard == null) continue;
                        try {
                            docsOnReplica = IndexShardTestCase.getDocIdAndSeqNos(replicaShard);
                        }
                        catch (AlreadyClosedException ex) {
                            continue;
                        }
                        Assert.assertThat((String)("out of sync shards: primary=[" + String.valueOf(primaryShardRouting) + "] num_docs_on_primary=[" + docsOnPrimary.size() + "] vs replica=[" + String.valueOf(replicaShardRouting) + "] num_docs_on_replica=[" + docsOnReplica.size() + "]"), docsOnReplica, (Matcher)Matchers.equalTo(docsOnPrimary));
                    }
                }
            }
        }));
    }

    private void randomlyResetClients() {
        assert (Thread.holdsLock(this));
        if (RandomizedTest.isNightly() && LuceneTestCase.rarely((Random)this.random)) {
            Collection nodesAndClients = this.nodes.values();
            logger.info("Resetting [{}] node clients on internal test cluster", (Object)nodesAndClients.size());
            for (NodeAndClient nodeAndClient : nodesAndClients) {
                logger.info("Resetting [{}] node client on internal test cluster", (Object)nodeAndClient.name);
                nodeAndClient.resetClient();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void wipePendingDataDirectories() {
        if (!this.dataDirToClean.isEmpty()) {
            try {
                for (Path path : this.dataDirToClean) {
                    try {
                        FileSystemUtils.deleteSubDirectories((Path[])new Path[]{path});
                        logger.info("Successfully wiped data directory for node location: {}", (Object)path);
                    }
                    catch (IOException e) {
                        logger.info("Failed to wipe data directory for node location: {}", (Object)path);
                    }
                }
            }
            finally {
                this.dataDirToClean.clear();
            }
        }
    }

    public ClusterService clusterService() {
        return this.clusterService(null);
    }

    public ClusterService clusterService(@Nullable String node) {
        return this.getInstance(ClusterService.class, node);
    }

    public <T> Iterable<T> getInstances(Class<T> clazz) {
        return this.nodes.values().stream().map(node -> InternalTestCluster.getInstanceFromNode(clazz, node.node)).collect(Collectors.toList());
    }

    public <T> Iterable<T> getDataNodeInstances(Class<T> clazz) {
        return this.getInstances(clazz, DATA_NODE_PREDICATE);
    }

    public synchronized <T> T getCurrentMasterNodeInstance(Class<T> clazz) {
        return this.getInstance(clazz, new NodeNamePredicate(this.getMasterName()));
    }

    public <T> Iterable<T> getDataOrMasterNodeInstances(Class<T> clazz) {
        return this.getInstances(clazz, DATA_NODE_PREDICATE.or(MASTER_NODE_PREDICATE));
    }

    private <T> Iterable<T> getInstances(Class<T> clazz, Predicate<NodeAndClient> predicate) {
        Iterable filteredNodes = this.nodes.values().stream().filter(predicate)::iterator;
        ArrayList<T> instances = new ArrayList<T>();
        for (NodeAndClient nodeAndClient : filteredNodes) {
            instances.add(InternalTestCluster.getInstanceFromNode(clazz, nodeAndClient.node));
        }
        return instances;
    }

    public <T> T getInstance(Class<T> clazz, @Nullable String nodeName) {
        return this.getInstance(clazz, nodeName == null ? Predicates.always() : new NodeNamePredicate(nodeName));
    }

    public <T> T getInstance(Class<T> clazz, final DiscoveryNodeRole role) {
        return this.getInstance(clazz, new Predicate<NodeAndClient>(this){

            @Override
            public boolean test(NodeAndClient nc) {
                return DiscoveryNode.getRolesFromSettings((Settings)nc.node.settings()).contains(role);
            }

            public String toString() {
                return "role: " + String.valueOf(role);
            }
        });
    }

    public <T> T getDataNodeInstance(Class<T> clazz) {
        return this.getInstance(clazz, DATA_NODE_PREDICATE);
    }

    public <T> T getAnyMasterNodeInstance(Class<T> clazz) {
        return this.getInstance(clazz, MASTER_NODE_PREDICATE);
    }

    private <T> T getInstance(Class<T> clazz, Predicate<NodeAndClient> predicate) {
        NodeAndClient randomNodeAndClient = this.getRandomNodeAndClient(predicate);
        if (randomNodeAndClient == null) {
            throw new AssertionError((Object)("no node matches [" + String.valueOf(predicate) + "]"));
        }
        return InternalTestCluster.getInstanceFromNode(clazz, randomNodeAndClient.node);
    }

    public <T> T getInstance(Class<T> clazz) {
        return this.getInstance(clazz, Predicates.always());
    }

    private static <T> T getInstanceFromNode(Class<T> clazz, Node node) {
        return (T)node.injector().getInstance(clazz);
    }

    public Settings dataPathSettings(String node) {
        return this.nodes.values().stream().filter(nc -> nc.name.equals(node)).findFirst().get().node().settings().filter(key -> key.equals(Environment.PATH_DATA_SETTING.getKey()) || key.equals(Environment.PATH_SHARED_DATA_SETTING.getKey()));
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    @Override
    public InetSocketAddress[] httpAddresses() {
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        for (HttpServerTransport httpServerTransport : this.getInstances(HttpServerTransport.class)) {
            addresses.add(httpServerTransport.boundAddress().publishAddress().address());
        }
        return addresses.toArray(new InetSocketAddress[0]);
    }

    public synchronized boolean stopRandomDataNode() throws IOException {
        this.ensureOpen();
        NodeAndClient nodeAndClient = this.getRandomNodeAndClient(DATA_NODE_PREDICATE);
        if (nodeAndClient != null) {
            logger.info("Closing random node [{}] ", (Object)nodeAndClient.name);
            this.stopNodesAndClient(nodeAndClient);
            return true;
        }
        return false;
    }

    public synchronized boolean stopNode(String nodeName) throws IOException {
        this.ensureOpen();
        Optional<NodeAndClient> nodeToStop = this.nodes.values().stream().filter(n -> n.getName().equals(nodeName)).findFirst();
        if (nodeToStop.isPresent()) {
            this.ensureNotTheLastMasterEligibleNode(nodeToStop.get());
            logger.info("Closing node [{}]", (Object)nodeToStop.get().name);
            this.stopNodesAndClient(nodeToStop.get());
            return true;
        }
        return false;
    }

    private void ensureNotTheLastMasterEligibleNode(NodeAndClient nodeAndClient) {
        if (this.nodePrefix.equals("node_s") && nodeAndClient.nodeAndClientId() < this.sharedNodesSeeds.length && nodeAndClient.isMasterEligible() && this.autoManageMasterNodes && this.nodes.values().stream().filter(NodeAndClient::isMasterEligible).filter(n -> n.nodeAndClientId() < this.sharedNodesSeeds.length).count() == 1L) {
            throw new AssertionError((Object)"Tried to stop the only master eligible shared node");
        }
    }

    public synchronized void stopCurrentMasterNode() throws IOException {
        this.ensureOpen();
        assert (this.size() > 0);
        String masterNodeName = this.getMasterName();
        NodeAndClient masterNode = (NodeAndClient)this.nodes.get(masterNodeName);
        assert (masterNode != null);
        logger.info("Closing master node [{}] ", (Object)masterNodeName);
        this.stopNodesAndClient(masterNode);
    }

    public synchronized void stopRandomNonMasterNode() throws IOException {
        NodeAndClient nodeAndClient = this.getRandomNodeAndClient(new NodeNamePredicate(this.getMasterName()).negate());
        if (nodeAndClient != null) {
            logger.info("Closing random non master node [{}] current master [{}] ", (Object)nodeAndClient.name, (Object)this.getMasterName());
            this.stopNodesAndClient(nodeAndClient);
        }
    }

    private synchronized void startAndPublishNodesAndClients(List<NodeAndClient> nodeAndClients) {
        if (nodeAndClients.size() > 0) {
            int newMasters = (int)nodeAndClients.stream().filter(NodeAndClient::isMasterEligible).filter(nac -> !this.nodes.containsKey(nac.name)).count();
            this.rebuildUnicastHostFiles(nodeAndClients);
            ESTestCase.runInParallel(nodeAndClients.size(), i -> ((NodeAndClient)nodeAndClients.get(i)).startNode());
            nodeAndClients.forEach(this::publishNode);
            if (this.autoManageMasterNodes && newMasters > 0) {
                this.validateClusterFormed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildUnicastHostFiles(List<NodeAndClient> newNodes) {
        Object object = this.discoveryFileMutex;
        synchronized (object) {
            try {
                Collection currentNodes = this.nodes.values();
                Stream unicastHosts = Stream.concat(currentNodes.stream(), newNodes.stream());
                List discoveryFileContents = unicastHosts.map(nac -> (TransportService)nac.node.injector().getInstance(TransportService.class)).filter(Objects::nonNull).map(TransportService::getLocalNode).filter(Objects::nonNull).filter(DiscoveryNode::isMasterNode).map(n -> n.getAddress().toString()).distinct().collect(Collectors.toList());
                Set configPaths = Stream.concat(currentNodes.stream(), newNodes.stream()).map(nac -> nac.node.getEnvironment().configDir()).collect(Collectors.toSet());
                logger.debug("configuring discovery with {} at {}", discoveryFileContents, configPaths);
                for (Path configPath : configPaths) {
                    Files.createDirectories(configPath, new FileAttribute[0]);
                    Files.write(configPath.resolve("unicast_hosts.txt"), discoveryFileContents, new OpenOption[0]);
                }
            }
            catch (IOException e) {
                throw new AssertionError("failed to configure file-based discovery", e);
            }
        }
    }

    public Collection<Path> configPaths() {
        return this.nodes.values().stream().map(nac -> nac.node.getEnvironment().configDir()).toList();
    }

    private void stopNodesAndClient(NodeAndClient nodeAndClient) throws IOException {
        this.stopNodesAndClients(Collections.singleton(nodeAndClient));
    }

    private synchronized void stopNodesAndClients(Collection<NodeAndClient> nodeAndClients) throws IOException {
        Set<String> excludedNodeIds = this.excludeMasters(nodeAndClients);
        for (NodeAndClient nodeAndClient : nodeAndClients) {
            this.removeDisruptionSchemeFromNode(nodeAndClient);
            NodeAndClient previous = this.removeNode(nodeAndClient);
            assert (previous == nodeAndClient);
            nodeAndClient.close();
        }
        this.removeExclusions(excludedNodeIds);
    }

    public void restartRandomDataNode() throws Exception {
        this.restartRandomDataNode(EMPTY_CALLBACK);
    }

    public synchronized void restartRandomDataNode(RestartCallback callback) throws Exception {
        this.ensureOpen();
        NodeAndClient nodeAndClient = this.getRandomNodeAndClient(DATA_NODE_PREDICATE);
        if (nodeAndClient != null) {
            this.restartNode(nodeAndClient, callback);
        }
    }

    public void restartNode(String nodeName) throws Exception {
        this.restartNode(nodeName, EMPTY_CALLBACK);
    }

    public synchronized void restartNode(String nodeName, RestartCallback callback) throws Exception {
        this.ensureOpen();
        NodeAndClient nodeAndClient = (NodeAndClient)this.nodes.get(nodeName);
        if (nodeAndClient != null) {
            this.restartNode(nodeAndClient, callback);
        }
    }

    public void fullRestart() throws Exception {
        this.fullRestart(EMPTY_CALLBACK);
    }

    public synchronized void rollingRestart(RestartCallback callback) throws Exception {
        int numNodesRestarted = 0;
        for (NodeAndClient nodeAndClient : this.nodes.values()) {
            callback.doAfterNodes(numNodesRestarted++, nodeAndClient.nodeClient());
            this.restartNode(nodeAndClient, callback);
        }
    }

    private void restartNode(NodeAndClient nodeAndClient, RestartCallback callback) throws Exception {
        assert (Thread.holdsLock(this));
        logger.info("Restarting node [{}] ", (Object)nodeAndClient.name);
        if (this.activeDisruptionScheme != null) {
            this.activeDisruptionScheme.removeFromNode(nodeAndClient.name, this);
        }
        Set<String> excludedNodeIds = this.excludeMasters(Collections.singleton(nodeAndClient));
        Settings newSettings = nodeAndClient.closeForRestart(callback);
        this.removeExclusions(excludedNodeIds);
        nodeAndClient.recreateNode(newSettings, () -> this.rebuildUnicastHostFiles(Collections.singletonList(nodeAndClient)));
        nodeAndClient.startNode();
        this.publishNode(nodeAndClient);
        if (callback.validateClusterForming() || !excludedNodeIds.isEmpty()) {
            this.validateClusterFormed();
        }
    }

    private NodeAndClient removeNode(NodeAndClient nodeAndClient) {
        assert (Thread.holdsLock(this));
        TreeMap<String, NodeAndClient> newNodes = new TreeMap<String, NodeAndClient>((SortedMap<String, NodeAndClient>)this.nodes);
        NodeAndClient previous = (NodeAndClient)newNodes.remove(nodeAndClient.name);
        this.nodes = Collections.unmodifiableNavigableMap(newNodes);
        return previous;
    }

    private Set<String> excludeMasters(Collection<NodeAndClient> nodeAndClients) {
        assert (Thread.holdsLock(this));
        HashSet<String> excludedNodeNames = new HashSet<String>();
        if (this.autoManageVotingExclusions && this.autoManageMasterNodes && nodeAndClients.size() > 0) {
            long currentMasters = this.nodes.values().stream().filter(NodeAndClient::isMasterEligible).count();
            long stoppingMasters = nodeAndClients.stream().filter(NodeAndClient::isMasterEligible).count();
            assert (stoppingMasters <= currentMasters) : currentMasters + " < " + stoppingMasters;
            if (stoppingMasters != currentMasters && stoppingMasters > 0L) {
                nodeAndClients.stream().filter(NodeAndClient::isMasterEligible).map(NodeAndClient::getName).forEach(excludedNodeNames::add);
                assert ((long)excludedNodeNames.size() == stoppingMasters);
                logger.info("adding voting config exclusions {} prior to restart/shutdown", excludedNodeNames);
                try {
                    this.client().execute(TransportAddVotingConfigExclusionsAction.TYPE, (ActionRequest)new AddVotingConfigExclusionsRequest(ESTestCase.TEST_REQUEST_TIMEOUT, excludedNodeNames.toArray(Strings.EMPTY_ARRAY))).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    ESTestCase.fail(e);
                }
            }
        }
        return excludedNodeNames;
    }

    private void removeExclusions(Set<String> excludedNodeIds) {
        assert (Thread.holdsLock(this));
        if (this.autoManageVotingExclusions && !excludedNodeIds.isEmpty()) {
            logger.info("removing voting config exclusions for {} after restart/shutdown", excludedNodeIds);
            try {
                Client client = this.getRandomNodeAndClient(node -> !excludedNodeIds.contains(node.name)).client();
                client.execute(TransportClearVotingConfigExclusionsAction.TYPE, (ActionRequest)new ClearVotingConfigExclusionsRequest(ESTestCase.TEST_REQUEST_TIMEOUT)).get();
            }
            catch (InterruptedException | ExecutionException e) {
                ESTestCase.fail(e);
            }
        }
    }

    public synchronized void fullRestart(RestartCallback callback) throws Exception {
        int numNodesRestarted = 0;
        Settings[] newNodeSettings = new Settings[this.nextNodeId.get()];
        ArrayList<NodeAndClient> toStartAndPublish = new ArrayList<NodeAndClient>();
        for (NodeAndClient nodeAndClient : this.nodes.values()) {
            Settings newSettings;
            callback.doAfterNodes(numNodesRestarted++, nodeAndClient.nodeClient());
            logger.info("Stopping and resetting node [{}] ", (Object)nodeAndClient.name);
            if (this.activeDisruptionScheme != null) {
                this.activeDisruptionScheme.removeFromNode(nodeAndClient.name, this);
            }
            newNodeSettings[nodeAndClient.nodeAndClientId()] = newSettings = nodeAndClient.closeForRestart(callback);
            toStartAndPublish.add(nodeAndClient);
        }
        callback.onAllNodesStopped();
        Randomness.shuffle(toStartAndPublish);
        for (NodeAndClient nodeAndClient : toStartAndPublish) {
            logger.info("recreating node [{}] ", (Object)nodeAndClient.name);
            nodeAndClient.recreateNode(newNodeSettings[nodeAndClient.nodeAndClientId()], () -> this.rebuildUnicastHostFiles(toStartAndPublish));
        }
        this.startAndPublishNodesAndClients(toStartAndPublish);
        if (callback.validateClusterForming()) {
            this.validateClusterFormed();
        }
    }

    public String getMasterName() {
        return this.getMasterName(null);
    }

    public String getMasterName(@Nullable String viaNode) {
        String string = viaNode = viaNode != null ? viaNode : this.getRandomNodeName();
        if (viaNode == null) {
            throw new AssertionError((Object)"Unable to get master name, no node found");
        }
        try {
            ClusterServiceUtils.awaitClusterState(state -> state.nodes().getMasterNode() != null, this.clusterService(viaNode));
            ClusterState state2 = ((ClusterStateResponse)((ClusterStateRequestBuilder)this.client(viaNode).admin().cluster().prepareState(ESTestCase.TEST_REQUEST_TIMEOUT).setLocal(true)).get()).getState();
            DiscoveryNode masterNode = state2.nodes().getMasterNode();
            if (masterNode == null) {
                throw new AssertionError((Object)"Master is not stable but the method expects a stable master node");
            }
            return masterNode.getName();
        }
        catch (Exception e) {
            logger.warn("Can't fetch cluster state", (Throwable)e);
            throw new RuntimeException("Can't get master node " + e.getMessage(), e);
        }
    }

    public String getNonMasterNodeName() {
        NodeAndClient randomNodeAndClient = this.getRandomNodeAndClient(new NodeNamePredicate(this.getMasterName()).negate());
        if (randomNodeAndClient != null) {
            return randomNodeAndClient.getName();
        }
        throw new AssertionError((Object)"No non-master node found");
    }

    public String getRandomNodeName() {
        return this.getNodeNameThat(Predicates.always());
    }

    public String getNodeNameThat(Predicate<Settings> predicate) {
        NodeAndClient nodeAndClient = this.getRandomNodeAndClient(nc -> predicate.test(nc.node.settings()));
        return nodeAndClient != null ? nodeAndClient.getName() : null;
    }

    synchronized Set<String> allDataNodesButN(int count) {
        int numNodes = this.numDataNodes() - count;
        assert (this.size() >= numNodes);
        Map<String, NodeAndClient> dataNodes = this.nodes.entrySet().stream().filter(entry -> DATA_NODE_PREDICATE.test((NodeAndClient)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        HashSet<String> set = new HashSet<String>();
        Iterator<String> iterator = dataNodes.keySet().iterator();
        for (int i = 0; i < numNodes; ++i) {
            assert (iterator.hasNext());
            set.add(iterator.next());
        }
        return set;
    }

    public synchronized Set<String> nodesInclude(String index) {
        if (this.clusterService().state().routingTable().hasIndex(index)) {
            List allShards = this.clusterService().state().routingTable().allShards(index);
            DiscoveryNodes discoveryNodes = this.clusterService().state().getNodes();
            HashSet<String> nodeNames = new HashSet<String>();
            for (ShardRouting shardRouting : allShards) {
                if (!shardRouting.assignedToNode()) continue;
                DiscoveryNode discoveryNode = discoveryNodes.get(shardRouting.currentNodeId());
                nodeNames.add(discoveryNode.getName());
            }
            return nodeNames;
        }
        return Collections.emptySet();
    }

    private List<Settings> bootstrapMasterNodeWithSpecifiedIndex(List<Settings> allNodesSettings) {
        assert (Thread.holdsLock(this));
        if (this.bootstrapMasterNodeIndex == -1 || this.bootstrapMasterNodeIndex == -2) {
            return allNodesSettings;
        }
        int currentNodeId = this.numMasterNodes() - 1;
        ArrayList<Settings> newSettings = new ArrayList<Settings>();
        for (Settings settings : allNodesSettings) {
            if (!DiscoveryNode.isMasterNode((Settings)settings)) {
                newSettings.add(settings);
                continue;
            }
            if (++currentNodeId != this.bootstrapMasterNodeIndex) {
                newSettings.add(settings);
                continue;
            }
            ArrayList<String> nodeNames = new ArrayList<String>();
            for (Settings nodeSettings : this.getDataOrMasterNodeInstances(Settings.class)) {
                if (!DiscoveryNode.isMasterNode((Settings)nodeSettings)) continue;
                nodeNames.add((String)Node.NODE_NAME_SETTING.get(nodeSettings));
            }
            for (Settings nodeSettings : allNodesSettings) {
                if (!DiscoveryNode.isMasterNode((Settings)nodeSettings)) continue;
                nodeNames.add((String)Node.NODE_NAME_SETTING.get(nodeSettings));
            }
            newSettings.add(Settings.builder().put(settings).putList(ClusterBootstrapService.INITIAL_MASTER_NODES_SETTING.getKey(), nodeNames).build());
            this.setBootstrapMasterNodeIndex(-2);
        }
        return newSettings;
    }

    public String startNode() {
        return this.startNode(Settings.EMPTY);
    }

    public String startNode(Settings.Builder settings) {
        return this.startNode(settings.build());
    }

    public String startNode(Settings settings) {
        return this.startNodes(settings).get(0);
    }

    public List<String> startNodes(int numOfNodes) {
        return this.startNodes(numOfNodes, Settings.EMPTY);
    }

    public List<String> startNodes(int numOfNodes, Settings settings) {
        return this.startNodes(Collections.nCopies(numOfNodes, settings).toArray(new Settings[0]));
    }

    public synchronized List<String> startNodes(Settings ... extraSettings) {
        int newMasterCount = Math.toIntExact(Stream.of(extraSettings).filter(DiscoveryNode::isMasterNode).count());
        ArrayList<NodeAndClient> nodeList = new ArrayList<NodeAndClient>();
        int prevMasterCount = this.getMasterNodesCount();
        assert (this.autoManageMasterNodes || this.bootstrapMasterNodeIndex != -1) : "if autoManageMasterNodes is false you must configure bootstrapping by calling setBootstrapMasterNodeIndex before starting the first node";
        int autoBootstrapMasterNodeIndex = this.autoManageMasterNodes && prevMasterCount == 0 && newMasterCount > 0 && Arrays.stream(extraSettings).allMatch(s -> !DiscoveryNode.isMasterNode((Settings)s) || "multi-node".equals(DiscoveryModule.DISCOVERY_TYPE_SETTING.get(s))) ? RandomNumbers.randomIntBetween((Random)this.random, (int)0, (int)(newMasterCount - 1)) : -1;
        int numOfNodes = extraSettings.length;
        int firstNodeId = this.nextNodeId.getAndIncrement();
        ArrayList<Settings> settings = new ArrayList<Settings>();
        for (int i = 0; i < numOfNodes; ++i) {
            settings.add(this.getNodeSettings(firstNodeId + i, this.random.nextLong(), extraSettings[i]));
        }
        this.nextNodeId.set(firstNodeId + numOfNodes);
        List initialMasterNodes = settings.stream().filter(DiscoveryNode::isMasterNode).map(arg_0 -> ((Setting)Node.NODE_NAME_SETTING).get(arg_0)).collect(Collectors.toList());
        List<Settings> updatedSettings = this.bootstrapMasterNodeWithSpecifiedIndex(settings);
        for (int i = 0; i < numOfNodes; ++i) {
            Settings nodeSettings = updatedSettings.get(i);
            Settings.Builder builder = Settings.builder();
            if (DiscoveryNode.isMasterNode((Settings)nodeSettings)) {
                if (autoBootstrapMasterNodeIndex == 0) {
                    builder.putList(ClusterBootstrapService.INITIAL_MASTER_NODES_SETTING.getKey(), initialMasterNodes);
                }
                --autoBootstrapMasterNodeIndex;
            }
            NodeAndClient nodeAndClient = this.buildNode(firstNodeId + i, builder.put(nodeSettings).build(), false, () -> this.rebuildUnicastHostFiles(nodeList));
            nodeList.add(nodeAndClient);
        }
        this.startAndPublishNodesAndClients(nodeList);
        if (this.autoManageMasterNodes) {
            this.validateClusterFormed();
        }
        return nodeList.stream().map(NodeAndClient::getName).collect(Collectors.toList());
    }

    public List<String> startMasterOnlyNodes(int numNodes) {
        return this.startMasterOnlyNodes(numNodes, Settings.EMPTY);
    }

    public List<String> startMasterOnlyNodes(int numNodes, Settings settings) {
        return this.startNodes(numNodes, Settings.builder().put(NodeRoles.onlyRole(settings, DiscoveryNodeRole.MASTER_ROLE)).build());
    }

    public List<String> startDataOnlyNodes(int numNodes) {
        return this.startDataOnlyNodes(numNodes, Settings.EMPTY);
    }

    public List<String> startDataOnlyNodes(int numNodes, Settings settings) {
        return this.startNodes(numNodes, Settings.builder().put(NodeRoles.onlyRole(settings, DiscoveryNodeRole.DATA_ROLE)).build());
    }

    private int getMasterNodesCount() {
        return (int)this.nodes.values().stream().filter(n -> DiscoveryNode.isMasterNode((Settings)n.node().settings())).count();
    }

    public String startMasterOnlyNode() {
        return this.startMasterOnlyNode(Settings.EMPTY);
    }

    public String startMasterOnlyNode(Settings settings) {
        Settings settings1 = Settings.builder().put(settings).put(NodeRoles.masterOnlyNode(settings)).build();
        return this.startNode(settings1);
    }

    public String startDataOnlyNode() {
        return this.startDataOnlyNode(Settings.EMPTY);
    }

    public String startDataOnlyNode(Settings settings) {
        return this.startNode(Settings.builder().put(settings).put(NodeRoles.dataOnlyNode(settings)).build());
    }

    private synchronized void publishNode(NodeAndClient nodeAndClient) {
        assert (!nodeAndClient.node().isClosed());
        TreeMap<String, NodeAndClient> newNodes = new TreeMap<String, NodeAndClient>((SortedMap<String, NodeAndClient>)this.nodes);
        newNodes.put(nodeAndClient.name, nodeAndClient);
        this.nodes = Collections.unmodifiableNavigableMap(newNodes);
        this.applyDisruptionSchemeToNode(nodeAndClient);
    }

    public void closeNonSharedNodes(boolean wipeData) throws IOException {
        this.reset(wipeData);
    }

    @Override
    public int numDataNodes() {
        return this.dataNodeAndClients().size();
    }

    @Override
    public int numDataAndMasterNodes() {
        return InternalTestCluster.filterNodes(this.nodes, DATA_NODE_PREDICATE.or(MASTER_NODE_PREDICATE)).size();
    }

    public int numMasterNodes() {
        return InternalTestCluster.filterNodes(this.nodes, NodeAndClient::isMasterEligible).size();
    }

    public Set<String> masterEligibleNodeNames() {
        Collection<NodeAndClient> masterEligibleNodes = InternalTestCluster.filterNodes(this.nodes, NodeAndClient::isMasterEligible);
        return masterEligibleNodes.stream().map(nodeAndClient -> nodeAndClient.name).collect(Collectors.toSet());
    }

    public void setDisruptionScheme(ServiceDisruptionScheme scheme) {
        assert (this.activeDisruptionScheme == null) : "there is already and active disruption [" + String.valueOf(this.activeDisruptionScheme) + "]. call clearDisruptionScheme first";
        scheme.applyToCluster(this);
        this.activeDisruptionScheme = scheme;
    }

    public void clearDisruptionScheme() {
        this.clearDisruptionScheme(true);
    }

    public synchronized void clearDisruptionScheme(boolean ensureHealthyCluster) {
        if (this.activeDisruptionScheme != null) {
            TimeValue expectedHealingTime = this.activeDisruptionScheme.expectedTimeToHeal();
            logger.info("Clearing active scheme {}, expected healing time {}", (Object)this.activeDisruptionScheme, (Object)expectedHealingTime);
            if (ensureHealthyCluster) {
                this.activeDisruptionScheme.removeAndEnsureHealthy(this);
            } else {
                this.activeDisruptionScheme.removeFromCluster(this);
            }
        }
        this.activeDisruptionScheme = null;
    }

    private void applyDisruptionSchemeToNode(NodeAndClient nodeAndClient) {
        if (this.activeDisruptionScheme != null) {
            assert (this.nodes.containsKey(nodeAndClient.name));
            this.activeDisruptionScheme.applyToNode(nodeAndClient.name, this);
        }
    }

    private void removeDisruptionSchemeFromNode(NodeAndClient nodeAndClient) {
        if (this.activeDisruptionScheme != null) {
            assert (this.nodes.containsKey(nodeAndClient.name));
            this.activeDisruptionScheme.removeFromNode(nodeAndClient.name, this);
        }
    }

    private Collection<NodeAndClient> dataNodeAndClients() {
        return InternalTestCluster.filterNodes(this.nodes, DATA_NODE_PREDICATE);
    }

    private static Collection<NodeAndClient> filterNodes(Map<String, NodeAndClient> map, Predicate<NodeAndClient> predicate) {
        return map.values().stream().filter(predicate).collect(Collectors.toCollection(ArrayList::new));
    }

    synchronized String routingKeyForShard(Index index, int shard, Random random) {
        Assert.assertThat((Object)shard, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0)));
        Assert.assertThat((Object)shard, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0)));
        for (NodeAndClient n : this.nodes.values()) {
            String routing;
            MockNode node = n.node;
            IndicesService indicesService = InternalTestCluster.getInstanceFromNode(IndicesService.class, node);
            ClusterService clusterService = InternalTestCluster.getInstanceFromNode(ClusterService.class, node);
            IndexService indexService = indicesService.indexService(index);
            if (indexService == null) continue;
            Assert.assertThat((Object)indexService.getIndexSettings().getSettings().getAsInt("index.number_of_shards", Integer.valueOf(-1)), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(shard)));
            ClusterState clusterState = clusterService.state();
            IndexRouting indexRouting = IndexRouting.fromIndexMetadata((IndexMetadata)clusterState.metadata().getProject().getIndexSafe(index));
            while (shard != indexRouting.indexShard("id", routing = RandomStrings.randomAsciiLettersOfLength((Random)random, (int)10), null, null)) {
            }
            return routing;
        }
        Assert.fail((String)("Could not find a node that holds " + String.valueOf(index)));
        return null;
    }

    @Override
    public Iterable<Client> getClients() {
        return () -> {
            this.ensureOpen();
            final Iterator iterator = this.nodes.values().iterator();
            return new Iterator<Client>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Client next() {
                    return ((NodeAndClient)iterator.next()).client();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("");
                }
            };
        };
    }

    @Override
    public NamedWriteableRegistry getNamedWriteableRegistry() {
        return this.getInstance(NamedWriteableRegistry.class);
    }

    public Settings getDefaultSettings() {
        return this.defaultSettings;
    }

    @Override
    public void ensureEstimatedStats() {
        if (this.size() > 0) {
            this.awaitIndexShardCloseAsyncTasks();
            for (NodeAndClient nodeAndClient : this.nodes.values()) {
                IndicesFieldDataCache fdCache = InternalTestCluster.getInstanceFromNode(IndicesService.class, nodeAndClient.node).getIndicesFieldDataCache();
                fdCache.getCache().refresh();
                String name = nodeAndClient.name;
                CircuitBreakerService breakerService = InternalTestCluster.getInstanceFromNode(CircuitBreakerService.class, nodeAndClient.node);
                CircuitBreaker fdBreaker = breakerService.getBreaker("fielddata");
                Assert.assertThat((String)("Fielddata breaker not reset to 0 on node: " + name), (Object)fdBreaker.getUsed(), (Matcher)Matchers.equalTo((Object)0L));
                try {
                    ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
                        CircuitBreaker reqBreaker = breakerService.getBreaker("request");
                        Assert.assertThat((String)("Request breaker not reset to 0 on node: " + name), (Object)reqBreaker.getUsed(), (Matcher)Matchers.equalTo((Object)0L));
                    }));
                }
                catch (Exception e) {
                    throw new AssertionError("Exception during check for request breaker reset to 0", e);
                }
                NodeService nodeService = InternalTestCluster.getInstanceFromNode(NodeService.class, nodeAndClient.node);
                CommonStatsFlags flags = new CommonStatsFlags(new CommonStatsFlags.Flag[]{CommonStatsFlags.Flag.FieldData, CommonStatsFlags.Flag.QueryCache, CommonStatsFlags.Flag.Segments});
                NodeStats stats = nodeService.stats(flags, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false);
                Assert.assertThat((String)("Fielddata size must be 0 on node: " + String.valueOf(stats.getNode())), (Object)stats.getIndices().getFieldData().getMemorySizeInBytes(), (Matcher)Matchers.equalTo((Object)0L));
                Assert.assertThat((String)("Query cache size must be 0 on node: " + String.valueOf(stats.getNode())), (Object)stats.getIndices().getQueryCache().getMemorySizeInBytes(), (Matcher)Matchers.equalTo((Object)0L));
                Assert.assertThat((String)("FixedBitSet cache size must be 0 on node: " + String.valueOf(stats.getNode())), (Object)stats.getIndices().getSegments().getBitsetMemoryInBytes(), (Matcher)Matchers.equalTo((Object)0L));
            }
        }
    }

    @Override
    public synchronized void assertAfterTest() throws Exception {
        super.assertAfterTest();
        this.assertRequestsFinished();
        this.assertSearchContextsReleased();
        this.assertNoInFlightDocsInEngine();
        this.assertMergeExecutorIsDone();
        this.awaitIndexShardCloseAsyncTasks();
        for (NodeAndClient nodeAndClient : this.nodes.values()) {
            NodeEnvironment env = nodeAndClient.node().getNodeEnvironment();
            Set shardIds = env.lockedShards();
            for (ShardId id : shardIds) {
                try {
                    env.shardLock(id, "InternalTestCluster assert after test", TimeUnit.SECONDS.toMillis(5L)).close();
                }
                catch (ShardLockObtainFailedException ex) {
                    throw new AssertionError("Shard " + String.valueOf(id) + " is still locked after 5 sec waiting", ex);
                }
            }
        }
    }

    public void assertRequestsFinished() {
        assert (Thread.holdsLock(this));
        if (this.size() > 0) {
            for (NodeAndClient nodeAndClient : this.nodes.values()) {
                CircuitBreaker inFlightRequestsBreaker = this.getInstance(CircuitBreakerService.class, nodeAndClient.name).getBreaker("inflight_requests");
                TaskManager taskManager = this.getInstance(TransportService.class, nodeAndClient.name).getTaskManager();
                try {
                    ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
                        long bytesUsed = inFlightRequestsBreaker.getUsed();
                        if (bytesUsed != 0L) {
                            String pendingTasks = taskManager.getTasks().values().stream().map(t -> t.taskInfo(nodeAndClient.name, true).toString()).collect(Collectors.joining(",", "[", "]"));
                            throw new AssertionError((Object)("All incoming requests on node [" + nodeAndClient.name + "] should have finished. Expected 0 bytes for requests in-flight but got " + bytesUsed + " bytes; pending tasks [" + pendingTasks + "]"));
                        }
                    }), 1L, TimeUnit.MINUTES);
                }
                catch (Exception e) {
                    logger.error("Could not assert finished requests within timeout", (Throwable)e);
                    Assert.fail((String)("Could not assert finished requests within timeout on node [" + nodeAndClient.name + "]"));
                }
            }
        }
    }

    private void assertSearchContextsReleased() {
        for (NodeAndClient nodeAndClient : this.nodes.values()) {
            ESTestCase.ensureAllContextsReleased(this.getInstance(SearchService.class, nodeAndClient.name));
        }
    }

    public void awaitIndexShardCloseAsyncTasks() {
        CountDownLatch latch = new CountDownLatch(1);
        try (RefCountingRunnable refs = new RefCountingRunnable(latch::countDown);){
            for (NodeAndClient nodeAndClient : this.nodes.values()) {
                Releasable ref = refs.acquire();
                InternalTestCluster.getInstanceFromNode(IndicesClusterStateService.class, nodeAndClient.node()).onClusterStateShardsClosed(() -> ((Releasable)ref).close());
            }
        }
        ESTestCase.safeAwait(latch);
    }

    public static interface EntitledNodePathsProvider {
        public Closeable addEntitledNodePaths(Settings var1, Path var2);
    }

    private final class NodeAndClient
    implements Closeable {
        private MockNode node;
        private final Settings originalNodeSettings;
        private volatile Client nodeClient;
        private final AtomicBoolean closed = new AtomicBoolean(false);
        private final String name;
        private final int nodeAndClientId;

        NodeAndClient(String name, MockNode node, Settings originalNodeSettings, int nodeAndClientId) {
            this.node = node;
            this.name = name;
            this.originalNodeSettings = originalNodeSettings;
            this.nodeAndClientId = nodeAndClientId;
            this.markNodeDataDirsAsNotEligibleForWipe();
        }

        Node node() {
            this.ensureNotClosed();
            return this.node;
        }

        private void ensureNotClosed() {
            if (this.closed.get()) {
                throw new RuntimeException("already closed");
            }
        }

        public int nodeAndClientId() {
            return this.nodeAndClientId;
        }

        public String getName() {
            return this.name;
        }

        public boolean isMasterEligible() {
            return DiscoveryNode.isMasterNode((Settings)this.node.settings());
        }

        Client client() {
            return this.getOrBuildNodeClient();
        }

        Client nodeClient() {
            return this.getOrBuildNodeClient();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Client getOrBuildNodeClient() {
            Client n = this.nodeClient;
            if (n != null) {
                this.ensureNotClosed();
                return n;
            }
            InternalTestCluster internalTestCluster = InternalTestCluster.this;
            synchronized (internalTestCluster) {
                this.ensureNotClosed();
                if (this.nodeClient == null) {
                    this.nodeClient = InternalTestCluster.this.clientWrapper.apply(this.node.client());
                }
                return this.nodeClient;
            }
        }

        void resetClient() {
            if (!this.closed.get()) {
                this.nodeClient = null;
            }
        }

        void startNode() {
            boolean success = false;
            try {
                this.node.start();
                success = true;
            }
            catch (NodeValidationException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable)((Object)this.node));
                }
            }
        }

        Settings closeForRestart(RestartCallback callback) throws Exception {
            assert (callback != null);
            this.close();
            InternalTestCluster.this.removeNode(this);
            Settings callbackSettings = callback.onNodeStopped(this.name);
            assert (callbackSettings != null);
            Settings.Builder newSettings = Settings.builder();
            if (InternalTestCluster.this.autoManageMasterNodes) {
                newSettings.putList(ClusterBootstrapService.INITIAL_MASTER_NODES_SETTING.getKey(), new String[0]);
            }
            newSettings.put(callbackSettings);
            this.clearDataIfNeeded(callback);
            return newSettings.build();
        }

        private void clearDataIfNeeded(RestartCallback callback) throws IOException {
            NodeEnvironment nodeEnv;
            if (callback.clearData(this.name) && (nodeEnv = this.node.getNodeEnvironment()).hasNodeFile()) {
                Object[] locations = nodeEnv.nodeDataPaths();
                logger.debug("removing node data paths: [{}]", (Object)Arrays.toString(locations));
                IOUtils.rm((Path[])locations);
            }
        }

        private void recreateNode(Settings newSettings, final Runnable onTransportServiceStarted) {
            if (!this.closed.get()) {
                throw new IllegalStateException("node " + this.name + " should be closed before recreating it");
            }
            long newIdSeed = (Long)NodeEnvironment.NODE_ID_SEED_SETTING.get(this.node.settings()) + 1L;
            Settings finalSettings = Settings.builder().put(this.originalNodeSettings).put(newSettings).put(NodeEnvironment.NODE_ID_SEED_SETTING.getKey(), newIdSeed).build();
            Collection<Class<? extends Plugin>> plugins = this.node.getClasspathPlugins();
            this.node = new MockNode(finalSettings, plugins, InternalTestCluster.this.forbidPrivateIndexSettings, InternalTestCluster.this.entitledNodePathsProvider.addEntitledNodePaths(finalSettings, null));
            ((TransportService)this.node.injector().getInstance(TransportService.class)).addLifecycleListener(new LifecycleListener(this){

                public void afterStart() {
                    onTransportServiceStarted.run();
                }
            });
            this.closed.set(false);
            this.markNodeDataDirsAsNotEligibleForWipe();
        }

        @Override
        public void close() throws IOException {
            assert (Thread.holdsLock(InternalTestCluster.this));
            try {
                this.resetClient();
            }
            finally {
                this.closed.set(true);
                this.markNodeDataDirsAsPendingForWipe();
                this.node.close();
                try {
                    if (!this.node.awaitClose(10L, TimeUnit.SECONDS)) {
                        throw new AssertionError((Object)"Node didn't close within 10 seconds.");
                    }
                }
                catch (InterruptedException e) {
                    throw new AssertionError("Interruption while waiting for the node to close", e);
                }
            }
        }

        private void markNodeDataDirsAsPendingForWipe() {
            assert (Thread.holdsLock(InternalTestCluster.this));
            NodeEnvironment nodeEnv = this.node.getNodeEnvironment();
            if (nodeEnv.hasNodeFile()) {
                InternalTestCluster.this.dataDirToClean.addAll(Arrays.asList(nodeEnv.nodeDataPaths()));
            }
        }

        private void markNodeDataDirsAsNotEligibleForWipe() {
            assert (Thread.holdsLock(InternalTestCluster.this));
            NodeEnvironment nodeEnv = this.node.getNodeEnvironment();
            if (nodeEnv.hasNodeFile()) {
                InternalTestCluster.this.dataDirToClean.removeAll(Arrays.asList(nodeEnv.nodeDataPaths()));
            }
        }
    }

    private record NodeNamePredicate(String nodeName) implements Predicate<NodeAndClient>
    {
        @Override
        public boolean test(NodeAndClient nodeAndClient) {
            return this.nodeName.equals(nodeAndClient.getName());
        }
    }

    public static class RestartCallback {
        public Settings onNodeStopped(String nodeName) throws Exception {
            return Settings.EMPTY;
        }

        public void onAllNodesStopped() throws Exception {
        }

        public void doAfterNodes(int n, Client client) throws Exception {
        }

        public boolean clearData(String nodeName) {
            return false;
        }

        public boolean validateClusterForming() {
            return true;
        }
    }
}

