/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datageneration.fields.leaf;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.datageneration.FieldDataGenerator;
import org.elasticsearch.datageneration.datasource.DataSource;
import org.elasticsearch.datageneration.datasource.DataSourceRequest;
import org.elasticsearch.datageneration.datasource.DataSourceResponse;
import org.elasticsearch.datageneration.fields.leaf.Wrappers;

public class GeoPointFieldDataGenerator
implements FieldDataGenerator {
    private final Supplier<Object> formattedPoints;
    private final Supplier<Object> formattedPointsWithMalformed;

    public GeoPointFieldDataGenerator(DataSource dataSource) {
        Supplier<Object> points = dataSource.get(new DataSourceRequest.GeoPointGenerator()).generator();
        DataSourceResponse.TransformWeightedWrapper representations = dataSource.get(new DataSourceRequest.TransformWeightedWrapper(List.of(Tuple.tuple((Object)0.2, p -> Map.of("type", "point", "coordinates", List.of(Double.valueOf(p.getLon()), Double.valueOf(p.getLat())))), Tuple.tuple((Object)0.2, p -> "POINT( " + p.getLon() + " " + p.getLat() + " )"), Tuple.tuple((Object)0.2, p -> Map.of("lon", p.getLon(), "lat", p.getLat())), Tuple.tuple((Object)0.2, p -> p.getLat() + "," + p.getLon()), Tuple.tuple((Object)0.2, GeoPoint::getGeohash))));
        Supplier<Object> pointRepresentations = representations.wrapper().apply(points);
        this.formattedPoints = Wrappers.defaults(pointRepresentations, dataSource);
        Supplier<String> strings = dataSource.get(new DataSourceRequest.StringGenerator()).generator();
        this.formattedPointsWithMalformed = Wrappers.defaultsWithMalformed(pointRepresentations, strings::get, dataSource);
    }

    @Override
    public Object generateValue(Map<String, Object> fieldMapping) {
        if (fieldMapping == null) {
            return null;
        }
        if (((Boolean)fieldMapping.getOrDefault("ignore_malformed", false)).booleanValue()) {
            return this.formattedPointsWithMalformed.get();
        }
        return this.formattedPoints.get();
    }
}

