/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.injection.guice;

import org.elasticsearch.injection.guice.Initializables;
import org.elasticsearch.injection.guice.InjectorImpl;
import org.elasticsearch.injection.guice.InternalFactoryToProviderAdapter;
import org.elasticsearch.injection.guice.Provider;
import org.elasticsearch.injection.guice.ProviderToInternalFactoryAdapter;
import org.elasticsearch.injection.guice.internal.InternalFactory;
import org.elasticsearch.injection.guice.internal.Scoping;

public class Scopes {
    private Scopes() {
    }

    static <T> InternalFactory<? extends T> scope(final InjectorImpl injector, final InternalFactory<? extends T> creator, Scoping scoping) {
        return switch (scoping) {
            default -> throw new MatchException(null, null);
            case Scoping.UNSCOPED -> creator;
            case Scoping.EAGER_SINGLETON -> new InternalFactoryToProviderAdapter(Initializables.of(new Provider<T>(){
                private volatile T instance;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T get() {
                    if (this.instance == null) {
                        InjectorImpl injectorImpl = injector;
                        synchronized (injectorImpl) {
                            if (this.instance == null) {
                                this.instance = new ProviderToInternalFactoryAdapter(injector, creator).get();
                            }
                        }
                    }
                    return this.instance;
                }

                public String toString() {
                    return String.valueOf(creator) + "[SINGLETON]";
                }
            }));
        };
    }
}

